// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Subtotal Parameter Set.
 */
public class WorkbookFunctionsSubtotalParameterSet {
    /**
     * The function Num.
     * 
     */
    @SerializedName(value = "functionNum", alternate = {"FunctionNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement functionNum;

    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;


    /**
     * Instiaciates a new WorkbookFunctionsSubtotalParameterSet
     */
    public WorkbookFunctionsSubtotalParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsSubtotalParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsSubtotalParameterSet(@Nonnull final WorkbookFunctionsSubtotalParameterSetBuilder builder) {
        this.functionNum = builder.functionNum;
        this.values = builder.values;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsSubtotalParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsSubtotalParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsSubtotalParameterSet
     */
    public static final class WorkbookFunctionsSubtotalParameterSetBuilder {
        /**
         * The functionNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement functionNum;
        /**
         * Sets the FunctionNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubtotalParameterSetBuilder withFunctionNum(@Nullable final com.google.gson.JsonElement val) {
            this.functionNum = val;
            return this;
        }
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubtotalParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsSubtotalParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsSubtotalParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsSubtotalParameterSet build() {
            return new WorkbookFunctionsSubtotalParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.functionNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("functionNum", functionNum));
        }
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        return result;
    }
}
