// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageTextInputQuestion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Text Input Question Request.
 */
public class AccessPackageTextInputQuestionRequest extends BaseRequest<AccessPackageTextInputQuestion> {
	
    /**
     * The request for the AccessPackageTextInputQuestion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageTextInputQuestionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageTextInputQuestion.class);
    }

    /**
     * Gets the AccessPackageTextInputQuestion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageTextInputQuestion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageTextInputQuestion from the service
     *
     * @return the AccessPackageTextInputQuestion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageTextInputQuestion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageTextInputQuestion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageTextInputQuestion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageTextInputQuestion with a source
     *
     * @param sourceAccessPackageTextInputQuestion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageTextInputQuestion> patchAsync(@Nonnull final AccessPackageTextInputQuestion sourceAccessPackageTextInputQuestion) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageTextInputQuestion);
    }

    /**
     * Patches this AccessPackageTextInputQuestion with a source
     *
     * @param sourceAccessPackageTextInputQuestion the source object with updates
     * @return the updated AccessPackageTextInputQuestion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageTextInputQuestion patch(@Nonnull final AccessPackageTextInputQuestion sourceAccessPackageTextInputQuestion) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageTextInputQuestion);
    }

    /**
     * Creates a AccessPackageTextInputQuestion with a new object
     *
     * @param newAccessPackageTextInputQuestion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageTextInputQuestion> postAsync(@Nonnull final AccessPackageTextInputQuestion newAccessPackageTextInputQuestion) {
        return sendAsync(HttpMethod.POST, newAccessPackageTextInputQuestion);
    }

    /**
     * Creates a AccessPackageTextInputQuestion with a new object
     *
     * @param newAccessPackageTextInputQuestion the new object to create
     * @return the created AccessPackageTextInputQuestion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageTextInputQuestion post(@Nonnull final AccessPackageTextInputQuestion newAccessPackageTextInputQuestion) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageTextInputQuestion);
    }

    /**
     * Creates a AccessPackageTextInputQuestion with a new object
     *
     * @param newAccessPackageTextInputQuestion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageTextInputQuestion> putAsync(@Nonnull final AccessPackageTextInputQuestion newAccessPackageTextInputQuestion) {
        return sendAsync(HttpMethod.PUT, newAccessPackageTextInputQuestion);
    }

    /**
     * Creates a AccessPackageTextInputQuestion with a new object
     *
     * @param newAccessPackageTextInputQuestion the object to create/update
     * @return the created AccessPackageTextInputQuestion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageTextInputQuestion put(@Nonnull final AccessPackageTextInputQuestion newAccessPackageTextInputQuestion) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageTextInputQuestion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageTextInputQuestionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageTextInputQuestionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

