// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AudioRoutingGroup;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audio Routing Group Request.
 */
public class AudioRoutingGroupRequest extends BaseRequest<AudioRoutingGroup> {
	
    /**
     * The request for the AudioRoutingGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AudioRoutingGroupRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AudioRoutingGroup.class);
    }

    /**
     * Gets the AudioRoutingGroup from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AudioRoutingGroup> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AudioRoutingGroup from the service
     *
     * @return the AudioRoutingGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AudioRoutingGroup get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AudioRoutingGroup> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AudioRoutingGroup delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AudioRoutingGroup with a source
     *
     * @param sourceAudioRoutingGroup the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AudioRoutingGroup> patchAsync(@Nonnull final AudioRoutingGroup sourceAudioRoutingGroup) {
        return sendAsync(HttpMethod.PATCH, sourceAudioRoutingGroup);
    }

    /**
     * Patches this AudioRoutingGroup with a source
     *
     * @param sourceAudioRoutingGroup the source object with updates
     * @return the updated AudioRoutingGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AudioRoutingGroup patch(@Nonnull final AudioRoutingGroup sourceAudioRoutingGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourceAudioRoutingGroup);
    }

    /**
     * Creates a AudioRoutingGroup with a new object
     *
     * @param newAudioRoutingGroup the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AudioRoutingGroup> postAsync(@Nonnull final AudioRoutingGroup newAudioRoutingGroup) {
        return sendAsync(HttpMethod.POST, newAudioRoutingGroup);
    }

    /**
     * Creates a AudioRoutingGroup with a new object
     *
     * @param newAudioRoutingGroup the new object to create
     * @return the created AudioRoutingGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AudioRoutingGroup post(@Nonnull final AudioRoutingGroup newAudioRoutingGroup) throws ClientException {
        return send(HttpMethod.POST, newAudioRoutingGroup);
    }

    /**
     * Creates a AudioRoutingGroup with a new object
     *
     * @param newAudioRoutingGroup the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AudioRoutingGroup> putAsync(@Nonnull final AudioRoutingGroup newAudioRoutingGroup) {
        return sendAsync(HttpMethod.PUT, newAudioRoutingGroup);
    }

    /**
     * Creates a AudioRoutingGroup with a new object
     *
     * @param newAudioRoutingGroup the object to create/update
     * @return the created AudioRoutingGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AudioRoutingGroup put(@Nonnull final AudioRoutingGroup newAudioRoutingGroup) throws ClientException {
        return send(HttpMethod.PUT, newAudioRoutingGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AudioRoutingGroupRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AudioRoutingGroupRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

