// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationStrengthPolicy;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.UpdateAllowedCombinationsResult;
import java.util.EnumSet;
import com.microsoft.graph.models.AuthenticationStrengthUsage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Policy Request.
 */
public class AuthenticationStrengthPolicyRequest extends BaseRequest<AuthenticationStrengthPolicy> {
	
    /**
     * The request for the AuthenticationStrengthPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationStrengthPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationStrengthPolicy.class);
    }

    /**
     * Gets the AuthenticationStrengthPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationStrengthPolicy from the service
     *
     * @return the AuthenticationStrengthPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationStrengthPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationStrengthPolicy with a source
     *
     * @param sourceAuthenticationStrengthPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthPolicy> patchAsync(@Nonnull final AuthenticationStrengthPolicy sourceAuthenticationStrengthPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationStrengthPolicy);
    }

    /**
     * Patches this AuthenticationStrengthPolicy with a source
     *
     * @param sourceAuthenticationStrengthPolicy the source object with updates
     * @return the updated AuthenticationStrengthPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthPolicy patch(@Nonnull final AuthenticationStrengthPolicy sourceAuthenticationStrengthPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationStrengthPolicy);
    }

    /**
     * Creates a AuthenticationStrengthPolicy with a new object
     *
     * @param newAuthenticationStrengthPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthPolicy> postAsync(@Nonnull final AuthenticationStrengthPolicy newAuthenticationStrengthPolicy) {
        return sendAsync(HttpMethod.POST, newAuthenticationStrengthPolicy);
    }

    /**
     * Creates a AuthenticationStrengthPolicy with a new object
     *
     * @param newAuthenticationStrengthPolicy the new object to create
     * @return the created AuthenticationStrengthPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthPolicy post(@Nonnull final AuthenticationStrengthPolicy newAuthenticationStrengthPolicy) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationStrengthPolicy);
    }

    /**
     * Creates a AuthenticationStrengthPolicy with a new object
     *
     * @param newAuthenticationStrengthPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthPolicy> putAsync(@Nonnull final AuthenticationStrengthPolicy newAuthenticationStrengthPolicy) {
        return sendAsync(HttpMethod.PUT, newAuthenticationStrengthPolicy);
    }

    /**
     * Creates a AuthenticationStrengthPolicy with a new object
     *
     * @param newAuthenticationStrengthPolicy the object to create/update
     * @return the created AuthenticationStrengthPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthPolicy put(@Nonnull final AuthenticationStrengthPolicy newAuthenticationStrengthPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationStrengthPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationStrengthPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationStrengthPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

