// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeGetCompatibleHubContentTypesCollectionRequest;
import com.microsoft.graph.requests.ContentTypeGetCompatibleHubContentTypesCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Get Compatible Hub Content Types Collection Request Builder.
 */
public class ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<ContentType, ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder, ContentTypeGetCompatibleHubContentTypesCollectionResponse, ContentTypeGetCompatibleHubContentTypesCollectionPage, ContentTypeGetCompatibleHubContentTypesCollectionRequest> {

    /**
     * The request builder for this collection of ContentType
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder.class, ContentTypeGetCompatibleHubContentTypesCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ContentTypeGetCompatibleHubContentTypesCollectionRequest instance
     */
    @Override
    @Nonnull
    public ContentTypeGetCompatibleHubContentTypesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ContentTypeGetCompatibleHubContentTypesCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
