// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CrossTenantAccessPolicyConfigurationDefault;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Access Policy Configuration Default Request.
 */
public class CrossTenantAccessPolicyConfigurationDefaultRequest extends BaseRequest<CrossTenantAccessPolicyConfigurationDefault> {
	
    /**
     * The request for the CrossTenantAccessPolicyConfigurationDefault
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CrossTenantAccessPolicyConfigurationDefaultRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CrossTenantAccessPolicyConfigurationDefault.class);
    }

    /**
     * Gets the CrossTenantAccessPolicyConfigurationDefault from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicyConfigurationDefault> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CrossTenantAccessPolicyConfigurationDefault from the service
     *
     * @return the CrossTenantAccessPolicyConfigurationDefault from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicyConfigurationDefault> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CrossTenantAccessPolicyConfigurationDefault with a source
     *
     * @param sourceCrossTenantAccessPolicyConfigurationDefault the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicyConfigurationDefault> patchAsync(@Nonnull final CrossTenantAccessPolicyConfigurationDefault sourceCrossTenantAccessPolicyConfigurationDefault) {
        return sendAsync(HttpMethod.PATCH, sourceCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Patches this CrossTenantAccessPolicyConfigurationDefault with a source
     *
     * @param sourceCrossTenantAccessPolicyConfigurationDefault the source object with updates
     * @return the updated CrossTenantAccessPolicyConfigurationDefault
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault patch(@Nonnull final CrossTenantAccessPolicyConfigurationDefault sourceCrossTenantAccessPolicyConfigurationDefault) throws ClientException {
        return send(HttpMethod.PATCH, sourceCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Creates a CrossTenantAccessPolicyConfigurationDefault with a new object
     *
     * @param newCrossTenantAccessPolicyConfigurationDefault the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicyConfigurationDefault> postAsync(@Nonnull final CrossTenantAccessPolicyConfigurationDefault newCrossTenantAccessPolicyConfigurationDefault) {
        return sendAsync(HttpMethod.POST, newCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Creates a CrossTenantAccessPolicyConfigurationDefault with a new object
     *
     * @param newCrossTenantAccessPolicyConfigurationDefault the new object to create
     * @return the created CrossTenantAccessPolicyConfigurationDefault
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault post(@Nonnull final CrossTenantAccessPolicyConfigurationDefault newCrossTenantAccessPolicyConfigurationDefault) throws ClientException {
        return send(HttpMethod.POST, newCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Creates a CrossTenantAccessPolicyConfigurationDefault with a new object
     *
     * @param newCrossTenantAccessPolicyConfigurationDefault the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicyConfigurationDefault> putAsync(@Nonnull final CrossTenantAccessPolicyConfigurationDefault newCrossTenantAccessPolicyConfigurationDefault) {
        return sendAsync(HttpMethod.PUT, newCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Creates a CrossTenantAccessPolicyConfigurationDefault with a new object
     *
     * @param newCrossTenantAccessPolicyConfigurationDefault the object to create/update
     * @return the created CrossTenantAccessPolicyConfigurationDefault
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault put(@Nonnull final CrossTenantAccessPolicyConfigurationDefault newCrossTenantAccessPolicyConfigurationDefault) throws ClientException {
        return send(HttpMethod.PUT, newCrossTenantAccessPolicyConfigurationDefault);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantAccessPolicyConfigurationDefaultRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantAccessPolicyConfigurationDefaultRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

