// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Edge;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Edge Request.
 */
public class EdgeRequest extends BaseRequest<Edge> {
	
    /**
     * The request for the Edge
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdgeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Edge.class);
    }

    /**
     * Gets the Edge from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Edge> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Edge from the service
     *
     * @return the Edge from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Edge get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Edge> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Edge delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Edge with a source
     *
     * @param sourceEdge the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Edge> patchAsync(@Nonnull final Edge sourceEdge) {
        return sendAsync(HttpMethod.PATCH, sourceEdge);
    }

    /**
     * Patches this Edge with a source
     *
     * @param sourceEdge the source object with updates
     * @return the updated Edge
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Edge patch(@Nonnull final Edge sourceEdge) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdge);
    }

    /**
     * Creates a Edge with a new object
     *
     * @param newEdge the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Edge> postAsync(@Nonnull final Edge newEdge) {
        return sendAsync(HttpMethod.POST, newEdge);
    }

    /**
     * Creates a Edge with a new object
     *
     * @param newEdge the new object to create
     * @return the created Edge
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Edge post(@Nonnull final Edge newEdge) throws ClientException {
        return send(HttpMethod.POST, newEdge);
    }

    /**
     * Creates a Edge with a new object
     *
     * @param newEdge the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Edge> putAsync(@Nonnull final Edge newEdge) {
        return sendAsync(HttpMethod.PUT, newEdge);
    }

    /**
     * Creates a Edge with a new object
     *
     * @param newEdge the object to create/update
     * @return the created Edge
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Edge put(@Nonnull final Edge newEdge) throws ClientException {
        return send(HttpMethod.PUT, newEdge);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdgeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdgeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

