// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EntitlementManagementSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Entitlement Management Settings Request.
 */
public class EntitlementManagementSettingsRequest extends BaseRequest<EntitlementManagementSettings> {
	
    /**
     * The request for the EntitlementManagementSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EntitlementManagementSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EntitlementManagementSettings.class);
    }

    /**
     * Gets the EntitlementManagementSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EntitlementManagementSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EntitlementManagementSettings from the service
     *
     * @return the EntitlementManagementSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EntitlementManagementSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EntitlementManagementSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EntitlementManagementSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EntitlementManagementSettings with a source
     *
     * @param sourceEntitlementManagementSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EntitlementManagementSettings> patchAsync(@Nonnull final EntitlementManagementSettings sourceEntitlementManagementSettings) {
        return sendAsync(HttpMethod.PATCH, sourceEntitlementManagementSettings);
    }

    /**
     * Patches this EntitlementManagementSettings with a source
     *
     * @param sourceEntitlementManagementSettings the source object with updates
     * @return the updated EntitlementManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EntitlementManagementSettings patch(@Nonnull final EntitlementManagementSettings sourceEntitlementManagementSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourceEntitlementManagementSettings);
    }

    /**
     * Creates a EntitlementManagementSettings with a new object
     *
     * @param newEntitlementManagementSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EntitlementManagementSettings> postAsync(@Nonnull final EntitlementManagementSettings newEntitlementManagementSettings) {
        return sendAsync(HttpMethod.POST, newEntitlementManagementSettings);
    }

    /**
     * Creates a EntitlementManagementSettings with a new object
     *
     * @param newEntitlementManagementSettings the new object to create
     * @return the created EntitlementManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EntitlementManagementSettings post(@Nonnull final EntitlementManagementSettings newEntitlementManagementSettings) throws ClientException {
        return send(HttpMethod.POST, newEntitlementManagementSettings);
    }

    /**
     * Creates a EntitlementManagementSettings with a new object
     *
     * @param newEntitlementManagementSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EntitlementManagementSettings> putAsync(@Nonnull final EntitlementManagementSettings newEntitlementManagementSettings) {
        return sendAsync(HttpMethod.PUT, newEntitlementManagementSettings);
    }

    /**
     * Creates a EntitlementManagementSettings with a new object
     *
     * @param newEntitlementManagementSettings the object to create/update
     * @return the created EntitlementManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EntitlementManagementSettings put(@Nonnull final EntitlementManagementSettings newEntitlementManagementSettings) throws ClientException {
        return send(HttpMethod.PUT, newEntitlementManagementSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EntitlementManagementSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EntitlementManagementSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

