// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LearningContent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Content Request.
 */
public class LearningContentRequest extends BaseRequest<LearningContent> {
	
    /**
     * The request for the LearningContent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LearningContentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LearningContent.class);
    }

    /**
     * Gets the LearningContent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningContent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LearningContent from the service
     *
     * @return the LearningContent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningContent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningContent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LearningContent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LearningContent with a source
     *
     * @param sourceLearningContent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningContent> patchAsync(@Nonnull final LearningContent sourceLearningContent) {
        return sendAsync(HttpMethod.PATCH, sourceLearningContent);
    }

    /**
     * Patches this LearningContent with a source
     *
     * @param sourceLearningContent the source object with updates
     * @return the updated LearningContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningContent patch(@Nonnull final LearningContent sourceLearningContent) throws ClientException {
        return send(HttpMethod.PATCH, sourceLearningContent);
    }

    /**
     * Creates a LearningContent with a new object
     *
     * @param newLearningContent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningContent> postAsync(@Nonnull final LearningContent newLearningContent) {
        return sendAsync(HttpMethod.POST, newLearningContent);
    }

    /**
     * Creates a LearningContent with a new object
     *
     * @param newLearningContent the new object to create
     * @return the created LearningContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningContent post(@Nonnull final LearningContent newLearningContent) throws ClientException {
        return send(HttpMethod.POST, newLearningContent);
    }

    /**
     * Creates a LearningContent with a new object
     *
     * @param newLearningContent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningContent> putAsync(@Nonnull final LearningContent newLearningContent) {
        return sendAsync(HttpMethod.PUT, newLearningContent);
    }

    /**
     * Creates a LearningContent with a new object
     *
     * @param newLearningContent the object to create/update
     * @return the created LearningContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningContent put(@Nonnull final LearningContent newLearningContent) throws ClientException {
        return send(HttpMethod.PUT, newLearningContent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LearningContentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LearningContentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

