// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.NamedLocation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Named Location Request.
 */
public class NamedLocationRequest extends BaseRequest<NamedLocation> {
	
    /**
     * The request for the NamedLocation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public NamedLocationRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends NamedLocation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the NamedLocation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NamedLocationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, NamedLocation.class);
    }

    /**
     * Gets the NamedLocation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NamedLocation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the NamedLocation from the service
     *
     * @return the NamedLocation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NamedLocation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NamedLocation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public NamedLocation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this NamedLocation with a source
     *
     * @param sourceNamedLocation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NamedLocation> patchAsync(@Nonnull final NamedLocation sourceNamedLocation) {
        return sendAsync(HttpMethod.PATCH, sourceNamedLocation);
    }

    /**
     * Patches this NamedLocation with a source
     *
     * @param sourceNamedLocation the source object with updates
     * @return the updated NamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NamedLocation patch(@Nonnull final NamedLocation sourceNamedLocation) throws ClientException {
        return send(HttpMethod.PATCH, sourceNamedLocation);
    }

    /**
     * Creates a NamedLocation with a new object
     *
     * @param newNamedLocation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NamedLocation> postAsync(@Nonnull final NamedLocation newNamedLocation) {
        return sendAsync(HttpMethod.POST, newNamedLocation);
    }

    /**
     * Creates a NamedLocation with a new object
     *
     * @param newNamedLocation the new object to create
     * @return the created NamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NamedLocation post(@Nonnull final NamedLocation newNamedLocation) throws ClientException {
        return send(HttpMethod.POST, newNamedLocation);
    }

    /**
     * Creates a NamedLocation with a new object
     *
     * @param newNamedLocation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NamedLocation> putAsync(@Nonnull final NamedLocation newNamedLocation) {
        return sendAsync(HttpMethod.PUT, newNamedLocation);
    }

    /**
     * Creates a NamedLocation with a new object
     *
     * @param newNamedLocation the object to create/update
     * @return the created NamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NamedLocation put(@Nonnull final NamedLocation newNamedLocation) throws ClientException {
        return send(HttpMethod.PUT, newNamedLocation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public NamedLocationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public NamedLocationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

