// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrintCertificateSigningRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Request Builder.
 */
public class PrinterRequestBuilder extends BaseRequestBuilder<Printer> {

    /**
     * The request builder for the Printer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrinterRequest instance
     */
    @Nonnull
    public PrinterRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PrinterRequest instance
     */
    @Nonnull
    public PrinterRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PrinterRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the PrintJob collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintJobCollectionRequestBuilder jobs() {
        return new com.microsoft.graph.requests.PrintJobCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("jobs"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintJob item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintJobRequestBuilder jobs(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintJobRequestBuilder(getRequestUrlWithAdditionalSegment("jobs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrintConnector collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintConnectorCollectionWithReferencesRequestBuilder connectors() {
        return new com.microsoft.graph.requests.PrintConnectorCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("connectors"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintConnector item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintConnectorWithReferenceRequestBuilder connectors(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintConnectorWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("connectors") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrinterShare collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequestBuilder shares() {
        return new com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("shares"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrinterShare item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterShareWithReferenceRequestBuilder shares(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrinterShareWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("shares") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrintTaskTrigger collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintTaskTriggerCollectionRequestBuilder taskTriggers() {
        return new com.microsoft.graph.requests.PrintTaskTriggerCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskTriggers"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintTaskTrigger item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintTaskTriggerRequestBuilder taskTriggers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintTaskTriggerRequestBuilder(getRequestUrlWithAdditionalSegment("taskTriggers") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public PrinterRestoreFactoryDefaultsRequestBuilder restoreFactoryDefaults() {
        return new PrinterRestoreFactoryDefaultsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.restoreFactoryDefaults"), getClient(), null);
    }
}
