// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SamlOrWsFedExternalDomainFederation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Saml Or Ws Fed External Domain Federation Request.
 */
public class SamlOrWsFedExternalDomainFederationRequest extends BaseRequest<SamlOrWsFedExternalDomainFederation> {
	
    /**
     * The request for the SamlOrWsFedExternalDomainFederation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SamlOrWsFedExternalDomainFederationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SamlOrWsFedExternalDomainFederation.class);
    }

    /**
     * Gets the SamlOrWsFedExternalDomainFederation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedExternalDomainFederation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SamlOrWsFedExternalDomainFederation from the service
     *
     * @return the SamlOrWsFedExternalDomainFederation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedExternalDomainFederation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedExternalDomainFederation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SamlOrWsFedExternalDomainFederation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SamlOrWsFedExternalDomainFederation with a source
     *
     * @param sourceSamlOrWsFedExternalDomainFederation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedExternalDomainFederation> patchAsync(@Nonnull final SamlOrWsFedExternalDomainFederation sourceSamlOrWsFedExternalDomainFederation) {
        return sendAsync(HttpMethod.PATCH, sourceSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Patches this SamlOrWsFedExternalDomainFederation with a source
     *
     * @param sourceSamlOrWsFedExternalDomainFederation the source object with updates
     * @return the updated SamlOrWsFedExternalDomainFederation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedExternalDomainFederation patch(@Nonnull final SamlOrWsFedExternalDomainFederation sourceSamlOrWsFedExternalDomainFederation) throws ClientException {
        return send(HttpMethod.PATCH, sourceSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Creates a SamlOrWsFedExternalDomainFederation with a new object
     *
     * @param newSamlOrWsFedExternalDomainFederation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedExternalDomainFederation> postAsync(@Nonnull final SamlOrWsFedExternalDomainFederation newSamlOrWsFedExternalDomainFederation) {
        return sendAsync(HttpMethod.POST, newSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Creates a SamlOrWsFedExternalDomainFederation with a new object
     *
     * @param newSamlOrWsFedExternalDomainFederation the new object to create
     * @return the created SamlOrWsFedExternalDomainFederation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedExternalDomainFederation post(@Nonnull final SamlOrWsFedExternalDomainFederation newSamlOrWsFedExternalDomainFederation) throws ClientException {
        return send(HttpMethod.POST, newSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Creates a SamlOrWsFedExternalDomainFederation with a new object
     *
     * @param newSamlOrWsFedExternalDomainFederation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedExternalDomainFederation> putAsync(@Nonnull final SamlOrWsFedExternalDomainFederation newSamlOrWsFedExternalDomainFederation) {
        return sendAsync(HttpMethod.PUT, newSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Creates a SamlOrWsFedExternalDomainFederation with a new object
     *
     * @param newSamlOrWsFedExternalDomainFederation the object to create/update
     * @return the created SamlOrWsFedExternalDomainFederation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedExternalDomainFederation put(@Nonnull final SamlOrWsFedExternalDomainFederation newSamlOrWsFedExternalDomainFederation) throws ClientException {
        return send(HttpMethod.PUT, newSamlOrWsFedExternalDomainFederation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SamlOrWsFedExternalDomainFederationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SamlOrWsFedExternalDomainFederationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

