// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServiceHealth;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Health Request.
 */
public class ServiceHealthRequest extends BaseRequest<ServiceHealth> {
	
    /**
     * The request for the ServiceHealth
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceHealthRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceHealth.class);
    }

    /**
     * Gets the ServiceHealth from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealth> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ServiceHealth from the service
     *
     * @return the ServiceHealth from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealth get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealth> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ServiceHealth delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ServiceHealth with a source
     *
     * @param sourceServiceHealth the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealth> patchAsync(@Nonnull final ServiceHealth sourceServiceHealth) {
        return sendAsync(HttpMethod.PATCH, sourceServiceHealth);
    }

    /**
     * Patches this ServiceHealth with a source
     *
     * @param sourceServiceHealth the source object with updates
     * @return the updated ServiceHealth
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealth patch(@Nonnull final ServiceHealth sourceServiceHealth) throws ClientException {
        return send(HttpMethod.PATCH, sourceServiceHealth);
    }

    /**
     * Creates a ServiceHealth with a new object
     *
     * @param newServiceHealth the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealth> postAsync(@Nonnull final ServiceHealth newServiceHealth) {
        return sendAsync(HttpMethod.POST, newServiceHealth);
    }

    /**
     * Creates a ServiceHealth with a new object
     *
     * @param newServiceHealth the new object to create
     * @return the created ServiceHealth
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealth post(@Nonnull final ServiceHealth newServiceHealth) throws ClientException {
        return send(HttpMethod.POST, newServiceHealth);
    }

    /**
     * Creates a ServiceHealth with a new object
     *
     * @param newServiceHealth the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealth> putAsync(@Nonnull final ServiceHealth newServiceHealth) {
        return sendAsync(HttpMethod.PUT, newServiceHealth);
    }

    /**
     * Creates a ServiceHealth with a new object
     *
     * @param newServiceHealth the object to create/update
     * @return the created ServiceHealth
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealth put(@Nonnull final ServiceHealth newServiceHealth) throws ClientException {
        return send(HttpMethod.PUT, newServiceHealth);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ServiceHealthRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ServiceHealthRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

