// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TodoTaskList;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task List Request.
 */
public class TodoTaskListRequest extends BaseRequest<TodoTaskList> {
	
    /**
     * The request for the TodoTaskList
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskListRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskList.class);
    }

    /**
     * Gets the TodoTaskList from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TodoTaskList> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TodoTaskList from the service
     *
     * @return the TodoTaskList from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TodoTaskList get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TodoTaskList> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TodoTaskList delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TodoTaskList with a source
     *
     * @param sourceTodoTaskList the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TodoTaskList> patchAsync(@Nonnull final TodoTaskList sourceTodoTaskList) {
        return sendAsync(HttpMethod.PATCH, sourceTodoTaskList);
    }

    /**
     * Patches this TodoTaskList with a source
     *
     * @param sourceTodoTaskList the source object with updates
     * @return the updated TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TodoTaskList patch(@Nonnull final TodoTaskList sourceTodoTaskList) throws ClientException {
        return send(HttpMethod.PATCH, sourceTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TodoTaskList> postAsync(@Nonnull final TodoTaskList newTodoTaskList) {
        return sendAsync(HttpMethod.POST, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the new object to create
     * @return the created TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TodoTaskList post(@Nonnull final TodoTaskList newTodoTaskList) throws ClientException {
        return send(HttpMethod.POST, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TodoTaskList> putAsync(@Nonnull final TodoTaskList newTodoTaskList) {
        return sendAsync(HttpMethod.PUT, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the object to create/update
     * @return the created TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TodoTaskList put(@Nonnull final TodoTaskList newTodoTaskList) throws ClientException {
        return send(HttpMethod.PUT, newTodoTaskList);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TodoTaskListRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TodoTaskListRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

