// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookApplication;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Application Request.
 */
public class WorkbookApplicationRequest extends BaseRequest<WorkbookApplication> {
	
    /**
     * The request for the WorkbookApplication
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookApplicationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookApplication.class);
    }

    /**
     * Gets the WorkbookApplication from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookApplication> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookApplication from the service
     *
     * @return the WorkbookApplication from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookApplication get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookApplication> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookApplication delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookApplication with a source
     *
     * @param sourceWorkbookApplication the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookApplication> patchAsync(@Nonnull final WorkbookApplication sourceWorkbookApplication) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookApplication);
    }

    /**
     * Patches this WorkbookApplication with a source
     *
     * @param sourceWorkbookApplication the source object with updates
     * @return the updated WorkbookApplication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookApplication patch(@Nonnull final WorkbookApplication sourceWorkbookApplication) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookApplication);
    }

    /**
     * Creates a WorkbookApplication with a new object
     *
     * @param newWorkbookApplication the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookApplication> postAsync(@Nonnull final WorkbookApplication newWorkbookApplication) {
        return sendAsync(HttpMethod.POST, newWorkbookApplication);
    }

    /**
     * Creates a WorkbookApplication with a new object
     *
     * @param newWorkbookApplication the new object to create
     * @return the created WorkbookApplication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookApplication post(@Nonnull final WorkbookApplication newWorkbookApplication) throws ClientException {
        return send(HttpMethod.POST, newWorkbookApplication);
    }

    /**
     * Creates a WorkbookApplication with a new object
     *
     * @param newWorkbookApplication the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookApplication> putAsync(@Nonnull final WorkbookApplication newWorkbookApplication) {
        return sendAsync(HttpMethod.PUT, newWorkbookApplication);
    }

    /**
     * Creates a WorkbookApplication with a new object
     *
     * @param newWorkbookApplication the object to create/update
     * @return the created WorkbookApplication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookApplication put(@Nonnull final WorkbookApplication newWorkbookApplication) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookApplication);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookApplicationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookApplicationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

