// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.AlertClassification;
import com.microsoft.graph.security.models.AlertComment;
import com.microsoft.graph.security.models.AlertDetermination;
import com.microsoft.graph.security.models.AlertSeverity;
import com.microsoft.graph.security.models.IncidentStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.security.requests.AlertCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Incident.
 */
public class Incident extends Entity implements IJsonBackedObject {


    /**
     * The Assigned To.
     * Owner of the incident, or null if no owner is assigned. Free editable text.
     */
    @SerializedName(value = "assignedTo", alternate = {"AssignedTo"})
    @Expose
	@Nullable
    public String assignedTo;

    /**
     * The Classification.
     * The specification for the incident. Possible values are: unknown, falsePositive, truePositive, informationalExpectedActivity, unknownFutureValue.
     */
    @SerializedName(value = "classification", alternate = {"Classification"})
    @Expose
	@Nullable
    public AlertClassification classification;

    /**
     * The Comments.
     * Array of comments created by the Security Operations (SecOps) team when the incident is managed.
     */
    @SerializedName(value = "comments", alternate = {"Comments"})
    @Expose
	@Nullable
    public java.util.List<AlertComment> comments;

    /**
     * The Created Date Time.
     * Time when the incident was first created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Custom Tags.
     * Array of custom tags associated with an incident.
     */
    @SerializedName(value = "customTags", alternate = {"CustomTags"})
    @Expose
	@Nullable
    public java.util.List<String> customTags;

    /**
     * The Determination.
     * Specifies the determination of the incident. Possible values are: unknown, apt, malware, securityPersonnel, securityTesting, unwantedSoftware, other, multiStagedAttack, compromisedUser, phishing, maliciousUserActivity, clean, insufficientData, confirmedUserActivity, lineOfBusinessApplication, unknownFutureValue.
     */
    @SerializedName(value = "determination", alternate = {"Determination"})
    @Expose
	@Nullable
    public AlertDetermination determination;

    /**
     * The Display Name.
     * The incident name.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Incident Web Url.
     * The URL for the incident page in the Microsoft 365 Defender portal.
     */
    @SerializedName(value = "incidentWebUrl", alternate = {"IncidentWebUrl"})
    @Expose
	@Nullable
    public String incidentWebUrl;

    /**
     * The Last Update Date Time.
     * Time when the incident was last updated.
     */
    @SerializedName(value = "lastUpdateDateTime", alternate = {"LastUpdateDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdateDateTime;

    /**
     * The Redirect Incident Id.
     * Only populated in case an incident is grouped together with another incident, as part of the logic that processes incidents. In such a case, the status property is redirected.
     */
    @SerializedName(value = "redirectIncidentId", alternate = {"RedirectIncidentId"})
    @Expose
	@Nullable
    public String redirectIncidentId;

    /**
     * The Severity.
     * Indicates the possible impact on assets. The higher the severity, the bigger the impact. Typically higher severity items require the most immediate attention. Possible values are: unknown, informational, low, medium, high, unknownFutureValue.
     */
    @SerializedName(value = "severity", alternate = {"Severity"})
    @Expose
	@Nullable
    public AlertSeverity severity;

    /**
     * The Status.
     * The status of the incident. Possible values are: active, resolved, inProgress, redirected, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public IncidentStatus status;

    /**
     * The Tenant Id.
     * The Azure Active Directory tenant in which the alert was created.
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;

    /**
     * The Alerts.
     * The list of related alerts. Supports $expand.
     */
	@Nullable
    public com.microsoft.graph.security.requests.AlertCollectionPage alerts;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("alerts")) {
            alerts = serializer.deserializeObject(json.get("alerts"), com.microsoft.graph.security.requests.AlertCollectionPage.class);
        }
    }
}
