// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Store;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Store Request.
 */
public class StoreRequest extends BaseRequest<Store> {
	
    /**
     * The request for the Store
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public StoreRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Store.class);
    }

    /**
     * Gets the Store from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Store> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Store from the service
     *
     * @return the Store from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Store get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Store> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Store delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Store with a source
     *
     * @param sourceStore the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Store> patchAsync(@Nonnull final Store sourceStore) {
        return sendAsync(HttpMethod.PATCH, sourceStore);
    }

    /**
     * Patches this Store with a source
     *
     * @param sourceStore the source object with updates
     * @return the updated Store
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Store patch(@Nonnull final Store sourceStore) throws ClientException {
        return send(HttpMethod.PATCH, sourceStore);
    }

    /**
     * Creates a Store with a new object
     *
     * @param newStore the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Store> postAsync(@Nonnull final Store newStore) {
        return sendAsync(HttpMethod.POST, newStore);
    }

    /**
     * Creates a Store with a new object
     *
     * @param newStore the new object to create
     * @return the created Store
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Store post(@Nonnull final Store newStore) throws ClientException {
        return send(HttpMethod.POST, newStore);
    }

    /**
     * Creates a Store with a new object
     *
     * @param newStore the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Store> putAsync(@Nonnull final Store newStore) {
        return sendAsync(HttpMethod.PUT, newStore);
    }

    /**
     * Creates a Store with a new object
     *
     * @param newStore the object to create/update
     * @return the created Store
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Store put(@Nonnull final Store newStore) throws ClientException {
        return send(HttpMethod.PUT, newStore);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public StoreRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public StoreRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

