/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier {
    private Set<JWSAlgorithm> acceptedAlgs = new HashSet<JWSAlgorithm>(this.supportedAlgorithms());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();

    public MACVerifier(byte[] sharedSecret) {
        super(sharedSecret);
    }

    public MACVerifier(String sharedSecretString) {
        super(sharedSecretString);
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWS algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        String jcaAlg = MACVerifier.getJCAAlgorithmName(header.getAlgorithm());
        if (!this.critParamChecker.headerPasses(header)) {
            return false;
        }
        byte[] hmac = HMAC.compute(jcaAlg, this.getSharedSecret(), signedContent, this.provider);
        Base64URL expectedSignature = Base64URL.encode(hmac);
        return expectedSignature.equals(signature);
    }
}

