/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.annotation.URLMapping;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCodeAnnotationFilter {
    private static final Log log = LogFactory.getLog(ByteCodeAnnotationFilter.class);
    private static final String SEARCH_STRING = "L" + URLMapping.class.getPackage().getName().replace('.', '/');
    private static final int CLASS_FILE_MAGIC = -889275714;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;

    public boolean accept(InputStream classFileStream) throws IOException {
        DataInputStream in = new DataInputStream(classFileStream);
        int magic = in.readInt();
        if (magic != -889275714) {
            if (log.isDebugEnabled()) {
                log.debug("Magic not found! Not a valid class file!");
            }
            return false;
        }
        int minor = in.readUnsignedShort();
        int major = in.readUnsignedShort();
        if (major < 49) {
            if (log.isTraceEnabled()) {
                log.trace("Not a JDK5 class! It cannot contain annotations!");
            }
            return false;
        }
        int constantPoolEntries = in.readUnsignedShort() - 1;
        block9: for (int i = 0; i < constantPoolEntries; ++i) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 7: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                case 8: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block9;
                }
                case 5: 
                case 6: {
                    in.readLong();
                    ++i;
                    continue block9;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                case 1: {
                    String str = in.readUTF();
                    if (!str.contains(SEARCH_STRING)) continue block9;
                    if (log.isTraceEnabled()) {
                        log.trace("Found PrettyFaces annotation reference in constant pool: " + str);
                    }
                    return true;
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown constant pool tag found: " + tag);
                    }
                    return true;
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("No reference to PrettyFaces annotations found!");
        }
        return false;
    }
}

