/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.mapping;

import com.ocpsoft.pretty.faces.el.ConstantExpression;
import com.ocpsoft.pretty.faces.el.PrettyExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathValidator {
    private int index;
    private String validatorIds = "";
    private PrettyExpression validatorExpression = null;
    private String onError = "";

    public PathValidator() {
    }

    public PathValidator(int index, String validatorIds, String onError) {
        this.index = index;
        this.validatorIds = validatorIds;
        this.onError = onError;
    }

    public boolean hasValidators() {
        return this.validatorIds.trim().length() > 0;
    }

    public List<String> getValidatorIdList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.hasValidators()) {
            String[] ids = this.validatorIds.split(" ");
            Collections.addAll(result, ids);
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getValidatorIds() {
        return this.validatorIds;
    }

    public void setValidatorIds(String validatorIds) {
        this.validatorIds = validatorIds;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public PrettyExpression getValidatorExpression() {
        return this.validatorExpression;
    }

    public void setValidatorExpression(PrettyExpression validatorExpression) {
        this.validatorExpression = validatorExpression;
    }

    public void setValidator(String validator) {
        this.validatorExpression = new ConstantExpression(validator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.onError == null ? 0 : this.onError.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.validatorIds == null ? 0 : this.validatorIds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathValidator other = (PathValidator)obj;
        if (this.onError == null ? other.onError != null : !this.onError.equals(other.onError)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.validatorIds == null ? other.validatorIds != null : !this.validatorIds.equals(other.validatorIds));
    }

    public String toString() {
        return "PathValidator [index=" + this.index + ", onError=" + this.onError + ", validatorIds=" + this.validatorIds + "]";
    }
}

