/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanNameResolver
implements ELBeanNameResolver {
    private static final Log log = LogFactory.getLog(SpringBeanNameResolver.class);
    private static final String WEB_APP_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
    private static final String GET_BEAN_NAMES_METHOD = "getBeanNamesForType";
    private static final String SCOPED_PROXY_UTILS_CLASS = "org.springframework.aop.scope.ScopedProxyUtils";
    private static final String GET_TARGET_BEAN_NAME_METHOD = "getTargetBeanName";
    private Method getBeanNamesMethod;
    private Method getTargetBeanNameMethod;
    private Object webAppContext;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        this.webAppContext = servletContext.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        if (this.webAppContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("WebApplicationContext not found in ServletContext. Resolver has been disabled.");
            }
            return false;
        }
        try {
            Class<?> webAppContextClass = classLoader.loadClass(WEB_APP_CONTEXT_CLASS);
            this.getBeanNamesMethod = webAppContextClass.getMethod(GET_BEAN_NAMES_METHOD, Class.class);
            if (log.isDebugEnabled()) {
                log.debug("Spring detected. Enabling Spring bean name resolving.");
            }
            this.getTargetBeanNameMethod = SpringBeanNameResolver.getProxyTargetBeanNameMethod(classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("WebApplicationContext class could not be found. Resolver has been disabled.");
            }
        }
        catch (NoSuchMethodException e) {
            log.warn("Cannot find getBeanNamesByType() method.", e);
        }
        catch (SecurityException e) {
            log.warn("Unable to init resolver due to security restrictions", e);
        }
        return false;
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            String[] names = (String[])this.getBeanNamesMethod.invoke(this.webAppContext, clazz);
            if (names == null || names.length == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("Spring doesn't know a name for class: " + clazz.getName());
                }
                return null;
            }
            if ((names = this.filterProxyNames(names)).length > 1) {
                log.warn("Spring returns more than one name for " + clazz.getName() + ". You should place a @URLBeanName annotation on the class.");
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace("Spring returned the name " + names[0] + " for class: " + clazz.getName());
            }
            return names[0];
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to call Spring due to security restrictions", e);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to query Spring for the bean name...", e);
        }
        return null;
    }

    private String[] filterProxyNames(String[] names) {
        if (this.getTargetBeanNameMethod == null) {
            return names;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = names.length - 1; i >= 0; --i) {
            String name = names[i];
            if (name == null) continue;
            boolean isTargetBeanName = false;
            for (int j = 0; !isTargetBeanName && j < names.length; ++j) {
                if (j == i) continue;
                try {
                    String targetBeanName = (String)this.getTargetBeanNameMethod.invoke(null, names[j]);
                    isTargetBeanName = name.equals(targetBeanName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.warn(String.format("Internal error invoking %s", this.getTargetBeanNameMethod.getName()), e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    log.warn(String.format("Error invoking %s due to security restrictions", this.getTargetBeanNameMethod.getName()));
                    continue;
                }
                catch (InvocationTargetException e) {
                    log.warn(String.format("Method %s has thrown an exception:", this.getTargetBeanNameMethod.getName()), e.getTargetException());
                }
            }
            if (isTargetBeanName) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    private static Method getProxyTargetBeanNameMethod(ClassLoader classLoader) {
        try {
            Class<?> scopedProxyUtilsClass = Class.forName(SCOPED_PROXY_UTILS_CLASS, true, classLoader);
            return scopedProxyUtilsClass.getMethod(GET_TARGET_BEAN_NAME_METHOD, String.class);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Could not find %s#%s method; filtering of proxy bean names has been disabled.", SCOPED_PROXY_UTILS_CLASS, GET_TARGET_BEAN_NAME_METHOD));
            }
        }
        catch (SecurityException e) {
            log.warn(String.format("Unable to find method %s on class %s due to security restrictions.", GET_TARGET_BEAN_NAME_METHOD, SCOPED_PROXY_UTILS_CLASS));
        }
        catch (NoSuchMethodException e) {
            log.warn(String.format("Cannot find method %s on class %s.", GET_TARGET_BEAN_NAME_METHOD, SCOPED_PROXY_UTILS_CLASS));
        }
        return null;
    }
}

