/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.svgsupport.OpenHtmlGvtFont;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;

public class OpenHtmlGvtFontFamily
implements GVTFontFamily {
    private final Map<FontDescriptor, OpenHtmlGvtFont> fonts = new HashMap<FontDescriptor, OpenHtmlGvtFont>(1);
    private final String fontFamily;

    public OpenHtmlGvtFontFamily(String family) {
        this.fontFamily = family;
    }

    public void addFont(byte[] bytes, float size, Float fontWeight, Float fontStyle) throws FontFormatException {
        FontDescriptor des = new FontDescriptor();
        des.size = Float.valueOf(size);
        des.style = fontStyle;
        des.weight = fontWeight;
        this.fonts.put(des, new OpenHtmlGvtFont(bytes, this, size, fontWeight, fontStyle));
    }

    public GVTFont deriveFont(float sz, AttributedCharacterIterator arg1) {
        return this.deriveFont(sz, arg1.getAttributes());
    }

    public GVTFont deriveFont(float size, Map attrs) {
        Float fontWeight = (Float)attrs.get(TextAttribute.WEIGHT);
        Float fontStyle = (Float)attrs.get(TextAttribute.POSTURE);
        Float sz = Float.valueOf(size);
        FontDescriptor des = new FontDescriptor();
        des.weight = fontWeight;
        des.style = fontStyle;
        des.size = sz;
        if (this.fonts.containsKey(des)) {
            return this.fonts.get(des);
        }
        return this.fonts.values().iterator().next().deriveFont(sz.floatValue());
    }

    public String getFamilyName() {
        return this.fontFamily;
    }

    public GVTFontFace getFontFace() {
        return new GVTFontFace(this.fontFamily);
    }

    public boolean isComplex() {
        return false;
    }

    private static class FontDescriptor {
        Float size;
        Float style;
        Float weight;

        private FontDescriptor() {
        }

        private boolean eq(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null) {
                return false;
            }
            return obj1.equals(obj2);
        }

        public boolean equals(Object obj) {
            return obj instanceof FontDescriptor && this.eq(((FontDescriptor)obj).style, this.style) && this.eq(((FontDescriptor)obj).weight, this.weight) && this.eq(((FontDescriptor)obj).size, this.size);
        }

        public int hashCode() {
            return (this.size == null ? 0 : this.size.hashCode()) + (this.style == null ? 0 : this.style.hashCode()) + (this.weight == null ? 0 : this.weight.hashCode());
        }
    }
}

