/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.extensible.Extensible;
import com.oracle.bedrock.extensible.Feature;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.commands.Inspect;
import com.oracle.bedrock.runtime.docker.commands.Remove;
import com.oracle.bedrock.runtime.docker.commands.Stop;
import com.oracle.bedrock.runtime.docker.options.ContainerCloseBehaviour;
import javax.json.JsonArray;
import javax.json.JsonValue;

public class DockerContainer
implements Feature,
ApplicationListener<Application> {
    private final String name;
    private final OptionsByType optionsByType;
    private Application application;
    private Platform platform;

    public DockerContainer(String name, OptionsByType optionsByType) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The container name cannot be null or empty String");
        }
        this.name = name;
        this.optionsByType = optionsByType == null ? OptionsByType.empty() : OptionsByType.of((OptionsByType)optionsByType);
    }

    public String getName() {
        return this.name;
    }

    public Application getApplication() {
        return this.application;
    }

    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    public Docker getDockerEnvironment() {
        return (Docker)this.optionsByType.get(Docker.class, new Object[0]);
    }

    public JsonValue inspect() {
        return this.inspect(null);
    }

    public JsonValue inspect(String format) {
        if (this.platform == null) {
            throw new IllegalStateException("No Platform is available, is this container a feature of an Application");
        }
        return this.createInspectCommand().format(format).run(this.platform, this.getDockerEnvironment());
    }

    Inspect createInspectCommand() {
        return Inspect.container(this.name);
    }

    public boolean isRunning() {
        JsonArray json = (JsonArray)this.inspect("{{.State.Running}}");
        return json.getBoolean(0);
    }

    public String getStatus() {
        JsonArray json = (JsonArray)this.inspect("{{.State.Status}}");
        return json.getString(0);
    }

    public void stop() {
        if (this.platform == null) {
            throw new IllegalStateException("No Platform is available, is this container a feature of an Application");
        }
        Docker docker = (Docker)this.optionsByType.get(Docker.class, new Object[0]);
        try (Application app = this.platform.launch((MetaClass)Stop.containers(this.name), new Option[]{docker});){
            app.waitFor(new Option[0]);
        }
    }

    public void remove(boolean force) {
        if (this.platform == null) {
            throw new IllegalStateException("No Platform is available, is this container a feature of an Application");
        }
        Docker docker = (Docker)this.optionsByType.get(Docker.class, new Object[0]);
        Remove.RemoveContainer removeCommand = force ? Remove.containers(this.name).force(true) : Remove.containers(this.name);
        try (Application app = this.platform.launch((MetaClass)removeCommand, new Option[]{docker});){
            app.waitFor(new Option[0]);
        }
    }

    public void onAddingTo(Extensible extensible) {
        this.application = (Application)extensible;
        this.platform = this.application.getPlatform();
    }

    public void onRemovingFrom(Extensible extensible) {
    }

    public void onLaunched(Application application) {
    }

    public void onClosing(Application application, OptionsByType optionsByType) {
    }

    public void onClosed(Application application, OptionsByType optionsByType) {
        OptionsByType closingOptions;
        if (application != null) {
            closingOptions = OptionsByType.of((OptionsByType)application.getOptions());
            closingOptions.addAll(optionsByType);
        } else {
            closingOptions = optionsByType;
        }
        ContainerCloseBehaviour behaviour = (ContainerCloseBehaviour)closingOptions.get(ContainerCloseBehaviour.class, new Object[0]);
        behaviour.accept(this);
    }
}

