/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.extensible.Extensible;
import com.oracle.bedrock.extensible.Feature;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.commands.Inspect;
import com.oracle.bedrock.runtime.docker.commands.Remove;
import com.oracle.bedrock.runtime.docker.options.ImageCloseBehaviour;
import java.util.Collections;
import java.util.List;
import javax.json.JsonValue;

public class DockerImage
implements Feature,
ApplicationListener<Application> {
    private final List<String> tags;
    private final OptionsByType optionsByType;
    private Application application;
    private Platform platform;

    public DockerImage(List<String> tags, OptionsByType optionsByType) {
        if (tags == null || tags.isEmpty()) {
            throw new IllegalArgumentException("The image tags cannot be null or empty List");
        }
        this.tags = tags;
        this.optionsByType = optionsByType == null ? OptionsByType.empty() : OptionsByType.of((OptionsByType)optionsByType);
    }

    public Application getApplication() {
        return this.application;
    }

    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    public List<String> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public String getFirstTag() {
        return this.tags.iterator().next();
    }

    public Docker getDockerEnvironment() {
        return (Docker)this.optionsByType.get(Docker.class, new Object[0]);
    }

    public JsonValue inspect() {
        if (this.platform == null) {
            throw new IllegalStateException("No Platform is available, is this image a feature of an Application");
        }
        return this.createInspectCommand().run(this.platform, this.getDockerEnvironment());
    }

    Inspect createInspectCommand() {
        return Inspect.image(this.tags);
    }

    public boolean remove() {
        if (this.platform == null) {
            throw new IllegalStateException("No Platform is available, is this image a feature of an Application");
        }
        try (Application app = this.platform.launch((MetaClass)Remove.images(this.tags), new Option[]{this.getDockerEnvironment()});){
            boolean bl = app.waitFor(new Option[0]) == 0;
            return bl;
        }
    }

    public void onAddingTo(Extensible extensible) {
        this.application = (Application)extensible;
        this.platform = this.application.getPlatform();
    }

    public void onRemovingFrom(Extensible extensible) {
    }

    public void onLaunched(Application application) {
    }

    public void onClosing(Application application, OptionsByType optionsByType) {
    }

    public void onClosed(Application application, OptionsByType optionsByType) {
        OptionsByType closingOptions;
        if (application != null) {
            closingOptions = OptionsByType.of((OptionsByType)application.getOptions());
            closingOptions.addAll(optionsByType);
        } else {
            closingOptions = optionsByType;
        }
        ImageCloseBehaviour behaviour = (ImageCloseBehaviour)closingOptions.get(ImageCloseBehaviour.class, new Object[0]);
        behaviour.accept(this);
    }
}

