/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.commands.AbstractDockerCommand;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CommandWithArgumentList<C extends CommandWithArgumentList>
extends AbstractDockerCommand<C> {
    private List<Argument> argumentList;

    protected CommandWithArgumentList(Arguments arguments, List<?> argList) {
        super(arguments);
        this.setArgList(argList);
    }

    protected CommandWithArgumentList(String command, List<?> argList) {
        super(command);
        this.setArgList(argList);
    }

    private void setArgList(List<?> values) {
        if (values == null || values.isEmpty()) {
            this.argumentList = Collections.emptyList();
        }
        this.argumentList = values.stream().filter(value -> value != null).map(x$0 -> Argument.of((Object)x$0, (Option[])new Option[0])).collect(Collectors.toList());
    }

    @Override
    public C withCommandArguments(Argument ... args) {
        return this.withCommandArguments(this.argumentList, args);
    }

    @Override
    public C withoutCommandArguments(Argument ... args) {
        return this.withoutCommandArguments(this.argumentList, args);
    }

    protected abstract C withCommandArguments(List<Argument> var1, Argument ... var2);

    protected abstract C withoutCommandArguments(List<Argument> var1, Argument ... var2);

    @Override
    public void onLaunch(Platform platform, OptionsByType optionsByType) {
        super.onLaunch(platform, optionsByType);
        this.argumentList.forEach(arg_0 -> ((OptionsByType)optionsByType).add(arg_0));
    }
}

