/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.docker.commands.CommandWithArgumentList;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import java.util.Collections;
import java.util.List;

public class Images
extends CommandWithArgumentList<Images> {
    public static final String FILTER_DANGLING = "dangling=true";
    public static final String FORMAT_ID = "{{.ID}}";
    public static final String FORMAT_REPOSITORY = "{{.Repository}}";
    public static final String FORMAT_TAG = "{{.Tag}}";
    public static final String FORMAT_DIGEST = "{{.Digest}}";
    public static final String FORMAT_CREATED_SINCE = "{{.CreatedSince}}";
    public static final String FORMAT_CREATED_AT = "{{.CreatedAt}}";
    public static final String FORMAT_SIZE = "{{.Size}}";

    private Images() {
        super("images", Collections.emptyList());
    }

    private Images(String repoTag) {
        super("images", Collections.singletonList(repoTag));
    }

    private Images(Arguments arguments, List<?> tags) {
        super(arguments, tags);
    }

    public Images all() {
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((Object)"--all", (Option[])new Option[0])});
    }

    public Images digests() {
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((Object)"--digests", (Option[])new Option[0])});
    }

    public Images filter(Object ... filters) {
        if (filters == null || filters.length == 0) {
            return this;
        }
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((String)"--filter", (char)'=', (Object)new Argument.Multiple(filters), (Option[])new Option[0])});
    }

    public Images format(Object ... formats) {
        if (formats == null || formats.length == 0) {
            return this;
        }
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((String)"--format", (char)'=', (Object)new Argument.Multiple(formats), (Option[])new Option[0])});
    }

    public Images noTruncate() {
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((Object)"--no-trunc", (Option[])new Option[0])});
    }

    public Images quiet() {
        return (Images)this.withCommandArguments(new Argument[]{Argument.of((Object)"--quiet", (Option[])new Option[0])});
    }

    public static Images list() {
        return new Images();
    }

    public static Images forRepo(String repoTag) {
        return new Images(repoTag);
    }

    @Override
    protected Images withCommandArguments(List<Argument> endArgs, Argument ... args) {
        return new Images(this.getCommandArguments().with(args), endArgs);
    }

    @Override
    protected Images withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
        return new Images(this.getCommandArguments().without(args), endArgs);
    }
}

