/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.commands.CommandWithArgumentList;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonValue;

public abstract class Network<C extends CommandWithArgumentList>
extends CommandWithArgumentList<C> {
    private Network(Arguments arguments, List<?> argList) {
        super(arguments, argList);
    }

    public static Create createBridge(String name) {
        return Network.create(name, "bridge");
    }

    public static Create createOverlay(String name) {
        return Network.create(name, "overlay");
    }

    public static Create create(String name, String driver) {
        return new Create(name, driver);
    }

    public static Connect connect(String network, String container) {
        return new Connect(network, container);
    }

    public static Disconnect disconnect(String network, String container) {
        return new Disconnect(network, container);
    }

    public static Inspect inspect(String ... names) {
        return Network.inspect(Arrays.asList(names));
    }

    public static Inspect inspect(List<String> names) {
        return new Inspect(names);
    }

    public static JsonValue inspect(Platform platform, Docker environment, String ... networks) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        Inspect inspect = Network.inspect(networks);
        try (Application app = platform.launch((MetaClass)inspect, new Option[]{environment, Console.of((ApplicationConsole)console)});){
            if (app.waitFor(new Option[0]) != 0) {
                console.getCapturedOutputLines().forEach(System.out::println);
                console.getCapturedErrorLines().forEach(System.err::println);
                JsonValue jsonValue = null;
                return jsonValue;
            }
        }
        Queue lines = console.getCapturedOutputLines();
        String json = lines.stream().filter(line -> line != null && !line.equals("(terminated)")).collect(Collectors.joining("\n")).trim();
        if (!json.startsWith("[") && !json.startsWith("{")) {
            json = "[" + json + "]";
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(json));
        try {
            return reader.read();
        }
        catch (Exception e) {
            System.err.println("Error parsing JSON");
            System.err.println(json);
            e.printStackTrace();
            return null;
        }
    }

    public static LS list() {
        return new LS();
    }

    public static Remove remove(String ... names) {
        return Network.remove(Arrays.asList(names));
    }

    public static Remove remove(List<String> names) {
        return new Remove(names);
    }

    public static class Remove
    extends Network<Remove> {
        private Remove(List<String> names) {
            super(Arguments.of((Object[])new Object[]{"network", "rm"}), names);
        }

        private Remove(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        @Override
        protected Remove withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Remove(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected Remove withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Remove(this.getCommandArguments().without(args), endArgs);
        }
    }

    public static class LS
    extends Network<LS> {
        private LS() {
            super(Arguments.of((Object[])new Object[]{"network", "ls"}), Collections.emptyList());
        }

        private LS(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        public LS filter(Object ... filters) {
            if (filters == null || filters.length == 0) {
                return this;
            }
            return (LS)this.withCommandArguments(new Argument[]{Argument.of((String)"--filter", (char)'=', (Object)new Argument.Multiple(filters), (Option[])new Option[0])});
        }

        public LS noTruncate() {
            return (LS)this.withCommandArguments(new Argument[]{Argument.of((Object)"--no-trunc", (Option[])new Option[0])});
        }

        public LS quiet() {
            return (LS)this.withCommandArguments(new Argument[]{Argument.of((Object)"--quiet", (Option[])new Option[0])});
        }

        @Override
        protected LS withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new LS(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected LS withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new LS(this.getCommandArguments().without(args), endArgs);
        }
    }

    public static class Inspect
    extends Network<Inspect> {
        private Inspect(List<String> names) {
            super(Arguments.of((Object[])new Object[]{"network", "inspect"}), names);
        }

        private Inspect(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        public Inspect format(String format) {
            if (format == null || format.trim().isEmpty()) {
                return this;
            }
            return (Inspect)this.withCommandArguments(new Argument[]{Argument.of((String)"--format", (char)'=', (Object)format, (Option[])new Option[0])});
        }

        @Override
        protected Inspect withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Inspect(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected Inspect withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Inspect(this.getCommandArguments().without(args), endArgs);
        }
    }

    public static class Disconnect
    extends Network<Disconnect> {
        private Disconnect(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        private Disconnect(String networkName, String containerName) {
            super(Arguments.of((Object[])new Object[]{"network", "disconnect"}), Arrays.asList(networkName, containerName));
        }

        public Disconnect force() {
            return (Disconnect)this.withCommandArguments(new Argument[]{Argument.of((Object)"--force", (Option[])new Option[0])});
        }

        @Override
        protected Disconnect withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Disconnect(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected Disconnect withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Disconnect(this.getCommandArguments().without(args), endArgs);
        }
    }

    public static class Create
    extends Network<Create> {
        private Create(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        private Create(String name, String driver) {
            super(Arguments.of((Object[])new Object[]{"network", "create", Argument.of((String)"--driver", (char)'=', (Object)driver, (Option[])new Option[0])}), Collections.singletonList(name));
        }

        public Create auxAddress(Object ... address) {
            if (address == null || address.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--aux-address", (char)'=', (Object)new Argument.Multiple(address), (Option[])new Option[0])});
        }

        public Create gateway(Object ... address) {
            if (address == null || address.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--gateway", (char)'=', (Object)new Argument.Multiple(address), (Option[])new Option[0])});
        }

        public Create internal() {
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((Object)"--internal", (Option[])new Option[0])});
        }

        public Create ipRange(Object ... range) {
            if (range == null || range.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--ip-range", (char)'=', (Object)new Argument.Multiple(range), (Option[])new Option[0])});
        }

        public Create ipamDriver(String driver) {
            if (driver == null || driver.trim().isEmpty()) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--ipam-driver", (char)'=', (Object)driver, (Option[])new Option[0])});
        }

        public Create ipamOpts(Object ... options) {
            if (options == null || options.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--ipam-opt", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0])});
        }

        public Create ipv6() {
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((Object)"--ipv6", (Option[])new Option[0])});
        }

        public Create labels(Object ... labels) {
            if (labels == null || labels.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--label", (char)'=', (Object)new Argument.Multiple(labels), (Option[])new Option[0])});
        }

        public Create driverOpts(Object ... options) {
            if (options == null || options.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--opt", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0])});
        }

        public Create subnet(Object ... cidr) {
            if (cidr == null || cidr.length == 0) {
                return this;
            }
            return (Create)this.withCommandArguments(new Argument[]{Argument.of((String)"--subnet", (char)'=', (Object)new Argument.Multiple(cidr), (Option[])new Option[0])});
        }

        @Override
        protected Create withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Create(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected Create withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Create(this.getCommandArguments().without(args), endArgs);
        }
    }

    public static class Connect
    extends Network<Connect> {
        private Connect(Arguments arguments, List<?> argList) {
            super(arguments, argList);
        }

        private Connect(String networkName, String containerName) {
            super(Arguments.of((Object[])new Object[]{"network", "connect"}), Arrays.asList(networkName, containerName));
        }

        public Connect alias(Object ... alias) {
            if (alias == null) {
                return this;
            }
            return (Connect)this.withCommandArguments(new Argument[]{Argument.of((String)"--alias", (char)'=', (Object)new Argument.Multiple(alias), (Option[])new Option[0])});
        }

        public Connect ip(Object address) {
            if (address == null) {
                return this;
            }
            return (Connect)this.withCommandArguments(new Argument[]{Argument.of((String)"--ip", (char)'=', (Object)address, (Option[])new Option[0])});
        }

        public Connect ip6(Object address) {
            if (address == null) {
                return this;
            }
            return (Connect)this.withCommandArguments(new Argument[]{Argument.of((String)"--ip6", (char)'=', (Object)address, (Option[])new Option[0])});
        }

        public Connect link(Object ... containers) {
            if (containers == null || containers.length == 0) {
                return this;
            }
            return (Connect)this.withCommandArguments(new Argument[]{Argument.of((String)"--link", (char)'=', (Object)new Argument.Multiple(containers), (Option[])new Option[0])});
        }

        @Override
        protected Connect withCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Connect(this.getCommandArguments().with(args), endArgs);
        }

        @Override
        protected Connect withoutCommandArguments(List<Argument> endArgs, Argument ... args) {
            return new Connect(this.getCommandArguments().without(args), endArgs);
        }
    }
}

