/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.machine;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.docker.DockerPlatform;
import com.oracle.bedrock.runtime.docker.machine.DockerMachinePlatform;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.EnvironmentVariable;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class DockerMachine {
    private static Logger LOGGER = Logger.getLogger(DockerPlatform.class.getName());
    private final String command = "docker-machine";
    private final Platform clientPlatform;
    private final Arguments arguments;

    private DockerMachine(Platform clientPlatform, Arguments arguments) {
        this.clientPlatform = clientPlatform;
        this.arguments = arguments;
    }

    public Platform getClientPlatform() {
        return this.clientPlatform;
    }

    public DockerMachine withCommandOptions(Argument ... args) {
        return new DockerMachine(this.clientPlatform, this.arguments.with(args));
    }

    public DockerMachine debug() {
        return this.withCommandOptions(Argument.of((Object)"--debug", (Option[])new Option[0]));
    }

    public DockerMachine storagePath(File path) {
        return this.withCommandOptions(Argument.of((String)"--storage-path", (char)'=', (Object)path, (Option[])new Option[0]));
    }

    public DockerMachine tlsCACert(Object cert) {
        return this.withCommandOptions(Argument.of((String)"--tls-ca-cert", (char)'=', (Object)cert, (Option[])new Option[0]));
    }

    public DockerMachine tlsCAKey(Object key) {
        return this.withCommandOptions(Argument.of((String)"--tls-ca-key", (char)'=', (Object)key, (Option[])new Option[0]));
    }

    public DockerMachine tlsClientCert(Object cert) {
        return this.withCommandOptions(Argument.of((String)"--tls-client-cert", (char)'=', (Object)cert, (Option[])new Option[0]));
    }

    public DockerMachine tlsPrivateKey(Object key) {
        return this.withCommandOptions(Argument.of((String)"--tls-client-key", (char)'=', (Object)key, (Option[])new Option[0]));
    }

    public DockerMachine githubToken(String token) {
        return this.withCommandOptions(Argument.of((String)"--github-api-token", (char)'=', (Object)token, (Option[])new Option[0]));
    }

    public DockerMachine nativeSSH() {
        return this.withCommandOptions(Argument.of((Object)"--native-ssh", (Option[])new Option[0]));
    }

    public DockerMachine bugSnagToken(String token) {
        return this.withCommandOptions(Argument.of((String)"--bugsnag-api-token", (char)'=', (Object)token, (Option[])new Option[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress getAddress(String machineName) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = this.launch("ip", new Option[]{Argument.of((Object)machineName, (Option[])new Option[0]), Console.of((ApplicationConsole)console)});){
            if (application.waitFor(new Option[0]) != 0) {
                String msg = "Error obtaining IP address for docker-machine " + machineName;
                this.logError(msg, console);
                throw new RuntimeException(msg);
            }
            String address = (String)console.getCapturedOutputLines().poll();
            InetAddress inetAddress = InetAddress.getByName(address);
            return inetAddress;
        }
        catch (Exception e) {
            throw new RuntimeException("Error obtaining IP address for docker-machine", e);
        }
    }

    public DockerMachinePlatform create(String machineName, Option ... options) {
        OptionsByType createOptions = OptionsByType.of((Option[])options);
        Timeout timeout = (Timeout)createOptions.getOrSetDefault(Timeout.class, (Option)Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES));
        try (Application create = this.launch("create", options);){
            if (create.waitFor(new Option[]{timeout}) != 0) {
                throw new RuntimeException("Error creating Docker Machine instance");
            }
        }
        OptionsByType platformOptions = OptionsByType.of((Option[])options);
        platformOptions.remove(Arguments.class);
        return new DockerMachinePlatform(this, machineName, platformOptions.asArray());
    }

    public Application launch(String command, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        Arguments arguments = (Arguments)optionsByType.get(Arguments.class, new Object[0]);
        Arguments launchArgs = this.arguments.with(Argument.of((Object)command, (Option[])new Option[0])).with(arguments);
        optionsByType.add((Option)launchArgs);
        return this.clientPlatform.launch(this.command, optionsByType.asArray());
    }

    public String status(String machineName) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = this.launch("status", new Option[]{Argument.of((Object)machineName, (Option[])new Option[0]), Console.of((ApplicationConsole)console)});){
            if (application.waitFor(new Option[0]) == 0) {
                String string = (String)console.getCapturedOutputLines().poll();
                return string;
            }
            this.logError("Error obtaining status for docker machine " + machineName, console);
            String string = "Error";
            return string;
        }
    }

    public JsonObject inspect(String machineName) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = this.launch("inspect", new Option[]{Argument.of((Object)machineName, (Option[])new Option[0]), Console.of((ApplicationConsole)console)});){
            if (application.waitFor(new Option[0]) != 0) {
                String msg = "Error inspecting docker machine " + machineName;
                this.logError(msg, console);
                throw new RuntimeException(msg);
            }
            String json = console.getCapturedOutputLines().stream().collect(Collectors.joining());
            JsonReader reader = Json.createReader((Reader)new StringReader(json));
            JsonObject jsonObject = (JsonObject)reader.read();
            return jsonObject;
        }
    }

    public int restart(String ... machineNames) {
        try (Application application = this.launch("restart", new Option[]{Arguments.of(Arrays.asList(machineNames))});){
            if (application.waitFor(new Option[0]) != 0) {
                LOGGER.log(Level.SEVERE, "Error restarting docker machines " + Arrays.toString(machineNames));
            }
            int n = application.exitValue();
            return n;
        }
    }

    public int remove(boolean force, String ... machineNames) {
        Arguments arguments = Arguments.empty();
        if (force) {
            arguments = arguments.with(new Argument[]{Argument.of((Object)"-y", (Option[])new Option[0]), Argument.of((Object)"--force", (Option[])new Option[0])});
        }
        arguments = arguments.with(Arrays.asList(machineNames));
        try (Application application = this.launch("rm", new Option[]{arguments});){
            if (application.waitFor(new Option[0]) != 0) {
                LOGGER.log(Level.SEVERE, "Error removing docker machines " + Arrays.toString(machineNames));
            }
            int n = application.exitValue();
            return n;
        }
    }

    public int stop(String ... machineNames) {
        try (Application application = this.launch("stop", new Option[]{Arguments.of(Arrays.asList(machineNames))});){
            if (application.waitFor(new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)}) != 0) {
                LOGGER.log(Level.SEVERE, "Error stopping docker machines " + Arrays.toString(machineNames));
            }
            int n = application.exitValue();
            return n;
        }
    }

    public int kill(String ... machineNames) {
        try (Application application = this.launch("kill", new Option[]{Arguments.of(Arrays.asList(machineNames))});){
            if (application.waitFor(new Option[0]) != 0) {
                LOGGER.log(Level.SEVERE, "Error killing docker machines " + Arrays.toString(machineNames));
            }
            int n = application.exitValue();
            return n;
        }
    }

    public List<EnvironmentVariable> environmentFor(String machineName) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        Throwable throwable = null;
        try (Application application = this.launch("env", new Option[]{Argument.of((Object)machineName, (Option[])new Option[0]), Console.of((ApplicationConsole)console)});){
            if (application.waitFor(new Option[0]) == 0) {
                List<EnvironmentVariable> list = console.getCapturedOutputLines().stream().filter(line -> line.startsWith("export")).map(line -> line.substring(7)).map(line -> {
                    int index = line.indexOf(61);
                    if (index >= 0) {
                        String name = line.substring(0, index);
                        String value = StringHelper.unquote((String)line.substring(index + 1));
                        return EnvironmentVariable.of((String)name, (String)value);
                    }
                    return EnvironmentVariable.of((String)line);
                }).collect(Collectors.toList());
                return list;
            }
            try {
                String msg = "Error obtaining environment for docker-machine " + machineName;
                this.logError(msg, console);
                throw new RuntimeException(msg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void logError(String msg, CapturingApplicationConsole console) {
        LOGGER.log(Level.SEVERE, msg);
        LOGGER.log(Level.SEVERE, Stream.concat(console.getCapturedOutputLines().stream(), console.getCapturedErrorLines().stream()).collect(Collectors.joining("\n")));
    }

    public static DockerMachine local() {
        return DockerMachine.at((Platform)LocalPlatform.get());
    }

    public static DockerMachine at(Platform platform) {
        return new DockerMachine(platform, Arguments.empty());
    }
}

