/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Application;
import java.util.HashMap;
import java.util.Map;

public class DockerDefaultBaseImages
implements Option {
    private final Class<? extends Application> applicationClass;
    private final String baseImageName;
    private final Map<Class<? extends Application>, DockerDefaultBaseImages> subClassBaseImages;

    private DockerDefaultBaseImages(DockerDefaultBaseImages toCopy) {
        this(toCopy.applicationClass, toCopy.baseImageName, new HashMap<Class<? extends Application>, DockerDefaultBaseImages>(toCopy.subClassBaseImages));
    }

    public DockerDefaultBaseImages(Class<? extends Application> applicationClass, String baseImageName) {
        this(applicationClass, baseImageName, new HashMap<Class<? extends Application>, DockerDefaultBaseImages>());
    }

    private DockerDefaultBaseImages(Class<? extends Application> applicationClass, String baseImageName, Map<Class<? extends Application>, DockerDefaultBaseImages> subClassBaseImages) {
        if (applicationClass == null) {
            throw new IllegalArgumentException("The application Class cannot be null");
        }
        if (baseImageName == null || baseImageName.trim().isEmpty()) {
            throw new IllegalArgumentException("The base image name cannot be null or blank");
        }
        this.applicationClass = applicationClass;
        this.baseImageName = baseImageName.trim();
        this.subClassBaseImages = subClassBaseImages;
    }

    public Class<? extends Application> getApplicationClass() {
        return this.applicationClass;
    }

    public synchronized DockerDefaultBaseImages with(Class<? extends Application> applicationClass, String baseImageName) {
        DockerDefaultBaseImages newInstance;
        if (applicationClass == null) {
            throw new IllegalArgumentException("Cannot add a null application Class");
        }
        if (baseImageName == null || baseImageName.trim().isEmpty()) {
            throw new IllegalArgumentException("The base image name cannot be null or blank");
        }
        if (this.applicationClass.equals(applicationClass)) {
            newInstance = new DockerDefaultBaseImages(this.applicationClass, baseImageName, new HashMap<Class<? extends Application>, DockerDefaultBaseImages>(this.subClassBaseImages));
        } else {
            if (applicationClass.isAssignableFrom(this.applicationClass)) {
                throw new IllegalArgumentException("Cannot add super class" + applicationClass + " to this tree class " + this.applicationClass);
            }
            DockerDefaultBaseImages parent = this.subClassBaseImages.values().stream().filter(value -> value.applicationClass.isAssignableFrom(applicationClass)).findFirst().orElse(null);
            if (parent != null) {
                DockerDefaultBaseImages newParent = parent.with(applicationClass, baseImageName);
                newInstance = new DockerDefaultBaseImages(this);
                newInstance.subClassBaseImages.put(newParent.applicationClass, newParent);
            } else {
                newInstance = new DockerDefaultBaseImages(this);
                newInstance.subClassBaseImages.put(applicationClass, new DockerDefaultBaseImages(applicationClass, baseImageName));
            }
        }
        return newInstance;
    }

    public String getBaseImage(Class<? extends Application> applicationClass) {
        if (this.applicationClass.equals(applicationClass)) {
            return this.baseImageName;
        }
        if (this.applicationClass.isAssignableFrom(applicationClass)) {
            return this.subClassBaseImages.values().stream().map(baseImage -> baseImage.getBaseImage(applicationClass)).filter(imageName -> imageName != null).findFirst().orElseGet(() -> this.baseImageName);
        }
        return null;
    }

    public static DockerDefaultBaseImages defaultImages() {
        return new DockerDefaultBaseImages(Application.class, "oraclelinux:7.1");
    }
}

