/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.Util;
import com.oracle.bedrock.runtime.remote.ssh.JSchSocketFactory;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;

public class HostBasedUserAuth
extends UserAuth {
    public static final String AUTH_HOSTBASED = "hostbased";

    public boolean start(Session session) throws Exception {
        super.start(session);
        Logger logger = JSch.getLogger();
        InetAddress localAddress = ((JSchSocketFactory)session.socket_factory).getLastLocalAddress();
        String localHostName = localAddress.getCanonicalHostName();
        Vector identities = session.jsch.getIdentityRepository().getIdentities();
        Iterator iterator = identities.iterator();
        boolean authenticated = false;
        while (!authenticated && iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            logger.log(0, "Trying hostbased auth with identity " + identity);
            byte[] publicKey = identity.getPublicKeyBlob();
            if (publicKey == null) {
                logger.log(0, "Identity " + identity + " has no public key blob");
                continue;
            }
            try {
                this.createAuthMessage(localHostName, identity.getAlgName(), publicKey);
                this.addSignature(session, identity);
                session.write(this.packet);
                authenticated = this.handleAuthResponse(session);
            }
            catch (JSchPartialAuthException partial) {
                if (partial.getMessage().toLowerCase().contains(AUTH_HOSTBASED)) {
                    logger.log(1, "Authentication failed for " + identity);
                    continue;
                }
                throw partial;
            }
            catch (Exception e) {
                logger.log(1, "Authentication failed for " + identity + " - " + e.getMessage());
            }
        }
        return authenticated;
    }

    protected void createAuthMessage(String localHostName, String algorithm, byte[] publicKeyBlob) throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)50);
        this.buf.putString(Util.str2byte((String)this.username));
        this.buf.putString(Util.str2byte((String)"ssh-connection"));
        this.buf.putString(Util.str2byte((String)AUTH_HOSTBASED));
        this.buf.putString(Util.str2byte((String)algorithm));
        this.buf.putString(publicKeyBlob);
        this.buf.putString(Util.str2byte((String)localHostName));
        this.buf.putString(Util.str2byte((String)this.username));
    }

    protected void addSignature(Session session, Identity identity) throws Exception {
        byte[] sessionId = session.getSessionId();
        Buffer buffer = new Buffer(sessionId.length + 4 + (this.buf.index - 5));
        buffer.putString(sessionId);
        buffer.putByte(this.buf.buffer, 5, this.buf.index - 5);
        byte[] signature = identity.getSignature(buffer.buffer);
        if (signature == null) {
            throw new JSchException("Could not obtain signature from identity " + identity);
        }
        this.buf.putString(signature);
    }

    protected boolean handleAuthResponse(Session session) throws Exception {
        int response;
        block5: while (true) {
            this.buf = session.read(this.buf);
            response = this.buf.getCommand() & 0xFF;
            switch (response) {
                case 52: {
                    return true;
                }
                case 51: {
                    this.handleFailure();
                    return false;
                }
                case 53: {
                    this.handleBanner();
                    continue block5;
                }
            }
            break;
        }
        Logger logger = JSch.getLogger();
        logger.log(2, "Unknown response code from server " + response);
        return false;
    }

    protected void handleBanner() {
        this.skipBytes(this.buf, 6);
        String banner = Util.byte2str((byte[])this.buf.getString());
        if (this.userinfo == null) {
            Logger logger = JSch.getLogger();
            logger.log(1, banner);
        } else {
            this.userinfo.showMessage(banner);
        }
    }

    protected void handleFailure() throws JSchPartialAuthException {
        this.skipBytes(this.buf, 6);
        String nameList = Util.byte2str((byte[])this.buf.getString());
        int partial = this.buf.getByte();
        if (partial != 0) {
            throw new JSchPartialAuthException(nameList);
        }
    }

    private void skipBytes(Buffer buffer, int count) {
        for (int i = 0; i < count; ++i) {
            buffer.getByte();
        }
    }
}

