/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.diagnostics.DiagnosticsRecording;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.options.Variables;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.ApplicationProcess;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.Profiles;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.options.Shell;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.DeployedArtifacts;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.RemoteTerminal;
import com.oracle.bedrock.runtime.remote.RemoteTerminalBuilder;
import com.oracle.bedrock.runtime.remote.RemoteTerminals;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.runtime.remote.options.Deployment;
import com.oracle.bedrock.runtime.remote.ssh.SftpDeployer;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.bedrock.table.Tabularize;
import com.oracle.bedrock.util.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Internal
public abstract class AbstractRemoteApplicationLauncher<A extends Application>
implements ApplicationLauncher<A>,
RemoteTerminal.Launchable {
    private static Logger LOGGER = Logger.getLogger(AbstractRemoteApplicationLauncher.class.getName());

    public A launch(final Platform platform, MetaClass<A> metaClass, OptionsByType optionsByType) {
        Application application;
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        if (platform != null) {
            diagnosticsTable.addRow(new String[]{"Target Platform", platform.getName()});
        }
        final OptionsByType launchOptions = OptionsByType.of((OptionsByType)platform.getOptions()).addAll(optionsByType);
        metaClass.onLaunching(platform, launchOptions);
        launchOptions.addIfAbsent((Option)PlatformSeparators.forUnix());
        launchOptions.addIfAbsent((Option)Shell.is((Shell.Type)Shell.Type.BASH));
        launchOptions.add((Option)Variable.with((String)"local.address", (Object)LocalPlatform.get().getAddress().getHostAddress()));
        launchOptions.add((Option)Variable.with((String)"bedrock.runtime.id", (Object)UUID.randomUUID()));
        launchOptions.addAll(Profiles.getProfiles());
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunching(platform, metaClass, launchOptions);
        }
        launchOptions.add((Option)diagnosticsTable);
        this.onLaunching(launchOptions);
        metaClass.onLaunch(platform, launchOptions);
        DisplayName displayName = this.getDisplayName(launchOptions);
        Executable executable = (Executable)launchOptions.get(Executable.class, new Object[0]);
        final ArrayList<DeploymentArtifact> artifactsToDeploy = new ArrayList<DeploymentArtifact>();
        Deployment deployment = (Deployment)launchOptions.get(Deployment.class, new Object[0]);
        if (deployment != null) {
            try {
                artifactsToDeploy.addAll(deployment.getDeploymentArtifacts(platform, launchOptions));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to determine artifacts to deploy", e);
            }
        }
        PlatformSeparators separators = (PlatformSeparators)launchOptions.get(PlatformSeparators.class, new Object[0]);
        WorkingDirectory workingDirectory = (WorkingDirectory)launchOptions.getOrSetDefault(WorkingDirectory.class, (Option)WorkingDirectory.temporaryDirectory());
        File remoteDirectoryFile = workingDirectory.resolve(platform, launchOptions);
        if (remoteDirectoryFile == null) {
            remoteDirectoryFile = WorkingDirectory.temporaryDirectory().resolve(platform, launchOptions);
        }
        String remoteDirectory = separators.asPlatformFileName(remoteDirectoryFile.toString());
        launchOptions.add((Option)WorkingDirectory.at((File)remoteDirectoryFile));
        if (remoteDirectoryFile != null) {
            diagnosticsTable.addRow(new String[]{"Working Directory", remoteDirectoryFile.toString()});
        }
        RemoteTerminalBuilder terminalBuilder = (RemoteTerminalBuilder)launchOptions.getOrSetDefault(RemoteTerminalBuilder.class, (Option)RemoteTerminals.ssh());
        RemoteTerminal terminal = terminalBuilder.build(platform);
        terminal.makeDirectories(remoteDirectory, launchOptions);
        final Deployer deployer = (Deployer)launchOptions.getOrSetDefault(Deployer.class, (Option)new SftpDeployer());
        final DeployedArtifacts deployedArtifacts = deployer.deploy(artifactsToDeploy, remoteDirectory, platform, launchOptions.asArray());
        deployedArtifacts.add(remoteDirectoryFile);
        if (!deployedArtifacts.isEmpty()) {
            launchOptions.add((Option)Decoration.of((Object)new ApplicationListener<A>(){

                public void onClosing(A application, OptionsByType optionsByType) {
                }

                public void onClosed(A application, OptionsByType optionsByType) {
                    try (DiagnosticsRecording diagnostics = DiagnosticsRecording.create((String)("Undeploy Diagnostics for " + application.getName() + " on platform " + platform.getName())).using(LOGGER, Level.INFO);){
                        diagnostics.add(new String[]{"Platform", "Resource"});
                        try (DiagnosticsRecording local = DiagnosticsRecording.section((String)"Local Platform");){
                            artifactsToDeploy.stream().filter(artifact -> artifact.isTemporary()).forEach(artifact -> {
                                try {
                                    artifact.getSourceFile().delete();
                                    local.add(new String[]{artifact.getSourceFile().toString()});
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to remove temporary " + artifact.toString() + " for application " + application.getName(), e);
                                    local.add(new String[]{artifact.getSourceFile() + " (failed to undeploy)"});
                                }
                            });
                        }
                        deployer.undeploy(deployedArtifacts, platform, launchOptions.asArray());
                    }
                }

                public void onLaunched(A application) {
                }
            }));
        }
        Arguments arguments = (Arguments)launchOptions.get(Arguments.class, new Object[0]);
        List argList = arguments.resolve(platform, launchOptions);
        launchOptions.add((Option)Arguments.of((List)argList));
        Class applicationClass = metaClass.getImplementationClass(platform, launchOptions);
        diagnosticsTable.addRow(new String[]{"Application", displayName.resolve(launchOptions)});
        if (argList.size() > 0) {
            diagnosticsTable.addRow(new String[]{"Application Arguments ", argList.stream().collect(Collectors.joining(" "))});
        }
        diagnosticsTable.addRow(new String[]{"Application Launch Time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
        RemoteApplicationProcess remoteProcess = terminal.launch(this, applicationClass, launchOptions);
        Object process = this.adapt(remoteProcess);
        try {
            Constructor constructor = ReflectionHelper.getCompatibleConstructor((Class)applicationClass, (Class[])new Class[]{platform.getClass(), process.getClass(), OptionsByType.class});
            application = (Application)constructor.newInstance(platform, process, launchOptions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate the Application class specified by the MetaClass:" + metaClass, e);
        }
        this.onLaunched(application, launchOptions);
        metaClass.onLaunched(platform, application, launchOptions);
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunched(platform, application, launchOptions);
        }
        for (ApplicationListener listener : launchOptions.getInstancesOf(ApplicationListener.class)) {
            listener.onLaunched(application);
        }
        return (A)application;
    }

    protected abstract void onLaunching(OptionsByType var1);

    protected abstract void onLaunched(A var1, OptionsByType var2);

    protected <P extends ApplicationProcess> P adapt(RemoteApplicationProcess process) {
        return (P)process;
    }

    @Override
    public String getCommandToExecute(Platform platform, OptionsByType optionsByType) {
        return ((Executable)optionsByType.get(Executable.class, new Object[0])).getName();
    }

    @Override
    public List<String> getCommandLineArguments(Platform platform, OptionsByType optionsByType) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("bedrock.runtime.inherit.")) continue;
            String propertyValue = System.getProperty(propertyName);
            ExpressionEvaluator evaluator = new ExpressionEvaluator((Variables)optionsByType.get(Variables.class, new Object[0]));
            propertyValue = (String)evaluator.evaluate(propertyValue, String.class);
            arguments.add(propertyValue);
        }
        List argList = ((Arguments)optionsByType.get(Arguments.class, new Object[0])).resolve(platform, optionsByType);
        arguments.addAll(argList);
        return arguments;
    }

    @Override
    public Properties getEnvironmentVariables(Platform platform, OptionsByType optionsByType) {
        Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
        EnvironmentVariables environmentVariables = (EnvironmentVariables)optionsByType.getOrSetDefault(EnvironmentVariables.class, (Option)EnvironmentVariables.of((EnvironmentVariables.Source)EnvironmentVariables.Source.TargetPlatform));
        Properties variables = new Properties();
        switch (environmentVariables.getSource()) {
            case Custom: {
                if (diagnosticsTable == null) break;
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(cleared)"});
                break;
            }
            case ThisApplication: {
                variables.putAll(System.getenv());
                if (diagnosticsTable == null) break;
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on parent process)"});
                break;
            }
            case TargetPlatform: {
                if (diagnosticsTable == null) break;
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on platform defaults)"});
            }
        }
        variables.putAll((Map<?, ?>)environmentVariables.realize(platform, optionsByType.asArray()));
        if (variables.size() > 0 && diagnosticsTable != null) {
            Table table = Tabularize.tabularize((Properties)variables);
            diagnosticsTable.addRow(new String[]{"", table.toString()});
        }
        return variables;
    }
}

