/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote;

import com.jcraft.jsch.HostBasedUserAuth;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.ssh.JSchBasedAuthentication;
import com.oracle.bedrock.util.Triple;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class HostBased
implements Authentication,
JSchBasedAuthentication {
    public static final byte[] NO_PASS_PHRASE = new byte[0];
    public static final String SSH_PREFERRED_AUTHENTICATIONS = "PreferredAuthentications";
    public static final String AUTH_HOSTBASED = "hostbased";
    private List<Triple<String, String, byte[]>> identities;

    public HostBased(String privateKeyFileName) {
        this(privateKeyFileName, null, NO_PASS_PHRASE);
    }

    public HostBased(String privateKey, byte[] passphrase) {
        this(privateKey, null, passphrase);
    }

    public HostBased(String privateKey, String passphrase) {
        this(privateKey, null, HostBased.stringToBytes(passphrase));
    }

    public HostBased(String privateKey, String publicKey, byte[] passphrase) {
        if (privateKey == null || privateKey.isEmpty()) {
            throw new IllegalArgumentException("The private key file name is required");
        }
        this.identities = new ArrayList<Triple<String, String, byte[]>>();
        this.identities.add((Triple<String, String, byte[]>)new Triple((Object)privateKey, (Object)publicKey, (Object)passphrase));
    }

    public HostBased(String privateKey, String publicKey, String passphrase) {
        this(privateKey, publicKey, HostBased.stringToBytes(passphrase));
    }

    public HostBased addIdentity(String privateKey) {
        return this.addIdentity(privateKey, null, NO_PASS_PHRASE);
    }

    public HostBased addIdentity(String privateKey, String passphrase) {
        return this.addIdentity(privateKey, null, HostBased.stringToBytes(passphrase));
    }

    public HostBased addIdentity(String privateKey, byte[] passphrase) {
        return this.addIdentity(privateKey, null, passphrase);
    }

    public HostBased addIdentity(String privateKey, String publicKey, String passphrase) {
        return this.addIdentity(privateKey, publicKey, HostBased.stringToBytes(passphrase));
    }

    public HostBased addIdentity(String privateKey, String publicKey, byte[] passphrase) {
        if (privateKey == null || privateKey.isEmpty()) {
            throw new IllegalArgumentException("The private key file name is required");
        }
        this.identities.add((Triple<String, String, byte[]>)new Triple((Object)privateKey, (Object)publicKey, (Object)passphrase));
        return this;
    }

    @Override
    public void configureFramework(JSch jsch) {
        try {
            for (Triple<String, String, byte[]> identity : this.identities) {
                String privateKey = (String)identity.getX();
                String publicKey = (String)identity.getY();
                byte[] passphrase = (byte[])identity.getZ();
                jsch.addIdentity(privateKey, publicKey, passphrase);
            }
        }
        catch (JSchException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void configureSession(Session session) {
        session.setConfig("userauth.hostbased", HostBasedUserAuth.class.getCanonicalName());
        String preferredAuthentications = session.getConfig(SSH_PREFERRED_AUTHENTICATIONS);
        if (preferredAuthentications != null) {
            String[] auths = preferredAuthentications.split(",");
            boolean hasHostBased = false;
            for (int i = 0; i < auths.length && !hasHostBased; ++i) {
                hasHostBased = auths[i].toLowerCase().equals(AUTH_HOSTBASED);
            }
            if (!hasHostBased) {
                session.setConfig(SSH_PREFERRED_AUTHENTICATIONS, "hostbased," + preferredAuthentications);
            }
        } else {
            session.setConfig(SSH_PREFERRED_AUTHENTICATIONS, AUTH_HOSTBASED);
        }
    }

    public static byte[] stringToBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

