/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.HttpProxy;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.http.HttpAuthenticationType;
import com.oracle.bedrock.runtime.remote.http.HttpBasedAuthentication;
import com.oracle.bedrock.runtime.remote.ssh.JSchBasedAuthentication;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;

public class Password
implements Authentication,
JSchBasedAuthentication,
HttpBasedAuthentication {
    private String password;

    public Password(String password) {
        this.password = password;
    }

    @Override
    public void configureFramework(JSch jsch) {
    }

    @Override
    public void configureSession(Session session) {
        session.setPassword(this.password);
    }

    @Override
    public HttpURLConnection openConnection(URL url, String userName, OptionsByType optionsByType) throws IOException {
        HttpURLConnection connection;
        HttpAuthenticationType authType = (HttpAuthenticationType)optionsByType.getOrSetDefault(HttpAuthenticationType.class, (Option)HttpAuthenticationType.Basic);
        HttpProxy proxy = (HttpProxy)optionsByType.getOrSetDefault(HttpProxy.class, (Option)HttpProxy.none());
        switch (authType) {
            case Basic: {
                String userPassword = userName + ":" + this.password;
                String encoding = Base64.getEncoder().encodeToString(userPassword.getBytes());
                connection = proxy.openConnection(url);
                connection.setRequestProperty("Authorization", "Basic " + encoding);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP authentication type " + (Object)((Object)authType));
            }
        }
        return connection;
    }
}

