/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.AbstractPlatform;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.SimpleRemoteApplicationLauncher;
import com.oracle.bedrock.runtime.remote.java.RemoteJavaApplicationLauncher;
import com.oracle.bedrock.util.Version;
import java.net.InetAddress;

public class RemotePlatform
extends AbstractPlatform {
    public static final int DEFAULT_PORT = 22;
    protected InetAddress address;
    protected int port;
    protected Authentication authentication;
    protected String userName;

    public RemotePlatform(InetAddress address, String userName, Authentication authentication, Option ... options) {
        this(address.toString(), address, 22, userName, authentication, options);
    }

    public RemotePlatform(String name, InetAddress address, String userName, Authentication authentication, Option ... options) {
        this(name, address, 22, userName, authentication, options);
    }

    public RemotePlatform(String name, InetAddress address, int port, String userName, Authentication authentication, Option ... options) {
        super(name, options);
        this.address = address;
        this.port = port;
        this.userName = userName;
        this.authentication = authentication;
    }

    public OperatingSystem getOperatingSystem() {
        return OperatingSystem.custom((String)"Generic", (String)"", (OperatingSystem.Type)OperatingSystem.Type.LINUX, (Version)Version.of((String[])new String[]{"1.0"}));
    }

    public InetAddress getAddress() {
        return this.address;
    }

    protected <A extends Application, B extends ApplicationLauncher<A>> B getApplicationLauncher(MetaClass<A> metaClass, OptionsByType optionsByType) throws UnsupportedOperationException {
        Class applicationClass = metaClass.getImplementationClass((Platform)this, optionsByType);
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new RemoteJavaApplicationLauncher();
        }
        return (B)new SimpleRemoteApplicationLauncher();
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }
}

