/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.ssh.JSchBasedAuthentication;

public class SecureKeys
implements Authentication,
JSchBasedAuthentication {
    private String privateKeyFileName;
    private String publicKeyFileName;

    private SecureKeys(String privateKeyFileName) {
        this(privateKeyFileName + ".pub", privateKeyFileName);
    }

    private SecureKeys(String publicKeyFileName, String privateKeyFileName) {
        this.privateKeyFileName = privateKeyFileName;
        this.publicKeyFileName = publicKeyFileName;
    }

    @Override
    public void configureFramework(JSch jsch) {
        try {
            jsch.addIdentity(this.privateKeyFileName, this.publicKeyFileName);
        }
        catch (JSchException e) {
            throw new RuntimeException("Failed to configure security framework", e);
        }
    }

    @Override
    public void configureSession(Session session) {
    }

    public static SecureKeys fromPrivateKeyFile(String privateKeyFileName) {
        return new SecureKeys(privateKeyFileName);
    }

    public static SecureKeys fromKeyFiles(String publicKeyFileName, String privateKeyFileName) {
        return new SecureKeys(publicKeyFileName, privateKeyFileName);
    }
}

