/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.http;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.remote.http.HttpDeployer;
import java.net.URL;

public class CurlHttpDeployer
extends HttpDeployer {
    public static final String DEFAULT_CURL = "curl";
    private final String curlCommand;

    public CurlHttpDeployer(Option ... options) {
        this(DEFAULT_CURL, new Option[0]);
    }

    public CurlHttpDeployer(String curlCommand, Option ... options) {
        super(options);
        this.curlCommand = curlCommand;
    }

    @Override
    protected void deployArtifact(URL sourceURL, String targetFileName, Platform platform) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = platform.launch(Application.class, new Option[]{Executable.named((String)this.curlCommand), Argument.of((Object)sourceURL.toExternalForm(), (Option[])new Option[0]), Argument.of((Object)"--create-dirs", (Option[])new Option[0]), Argument.of((Object)"-o", (Option[])new Option[0]), Argument.of((Object)StringHelper.doubleQuoteIfNecessary((String)targetFileName), (Option[])new Option[0]), DisplayName.of((String)"Deploy"), Console.of((ApplicationConsole)console)});){
            if (application.waitFor(new Option[0]) != 0) {
                StringBuilder message = new StringBuilder("Error deploying ").append(targetFileName).append(" - curl returned ").append(application.exitValue()).append("\n").append("curl output:");
                for (String line : console.getCapturedOutputLines()) {
                    message.append(line);
                }
                for (String line : console.getCapturedErrorLines()) {
                    message.append(line);
                }
                throw new RuntimeException(message.toString());
            }
        }
    }
}

