/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.http;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.io.NetworkHelper;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.remote.DeployedArtifacts;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.http.CurlHttpDeployer;
import com.oracle.bedrock.runtime.remote.http.WGetHttpDeployer;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;

public abstract class HttpDeployer
implements Deployer {
    private OptionsByType optionsByType;

    public HttpDeployer(Option ... options) {
        this.optionsByType = OptionsByType.of((Option[])options);
    }

    public HttpDeployer withBufferSize(int size) {
        this.optionsByType.add((Option)new BufferSize(size));
        return this;
    }

    public HttpDeployer withBufferSizeInKB(int size) {
        return this.withBufferSize(size * 1024);
    }

    public HttpDeployer withBufferSizeInMB(int size) {
        return this.withBufferSize(size * 1024 * 1024);
    }

    public static HttpDeployer wget(Option ... options) {
        return new WGetHttpDeployer(options);
    }

    public static HttpDeployer wgetAt(String wgetLocation, Option ... options) {
        return new WGetHttpDeployer(wgetLocation, options);
    }

    public static HttpDeployer curl(Option ... options) {
        return new CurlHttpDeployer(options);
    }

    public static HttpDeployer curlAt(String curlLocation, Option ... options) {
        return new CurlHttpDeployer(curlLocation, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployedArtifacts deploy(List<DeploymentArtifact> artifactsToDeploy, String remoteDirectory, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts deployedArtifacts = new DeployedArtifacts();
        if (artifactsToDeploy == null || artifactsToDeploy.isEmpty()) {
            return deployedArtifacts;
        }
        OptionsByType optionsByType = OptionsByType.empty();
        optionsByType.addAll(platform.getOptions());
        optionsByType.addAll(deploymentOptions);
        LinkedHashMap<String, DeploymentArtifact> artifactMap = new LinkedHashMap<String, DeploymentArtifact>();
        ExecutorService executor = this.createExecutor();
        HttpServer server = null;
        try {
            for (DeploymentArtifact artifact : artifactsToDeploy) {
                artifactMap.put("/" + UUID.randomUUID().toString(), artifact);
            }
            server = this.createServer(executor, artifactMap);
            this.deployAllArtifacts(artifactMap, remoteDirectory, platform, server.getAddress(), optionsByType, deployedArtifacts);
        }
        finally {
            if (server != null) {
                server.stop(0);
            }
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return deployedArtifacts;
    }

    protected void deployAllArtifacts(Map<String, DeploymentArtifact> artifacts, String remoteDirectory, Platform platform, InetSocketAddress httpServerAddress, OptionsByType optionsByType, DeployedArtifacts deployedArtifacts) {
        if (artifacts == null || artifacts.isEmpty()) {
            return;
        }
        try {
            PlatformSeparators separators = (PlatformSeparators)optionsByType.get(PlatformSeparators.class, new Object[0]);
            Table deploymentTable = new Table(new Row[0]);
            String hostAddress = httpServerAddress.getAddress().getHostAddress();
            int port = httpServerAddress.getPort();
            for (Map.Entry<String, DeploymentArtifact> entry : artifacts.entrySet()) {
                String destinationFileName;
                String destinationParentFolder;
                DeploymentArtifact artifact = entry.getValue();
                File sourceFile = artifact.getSourceFile();
                URL sourceURL = new URL("http", hostAddress, port, entry.getKey());
                File destinationFile = artifact.getDestinationFile();
                double start = System.currentTimeMillis();
                if (destinationFile == null) {
                    destinationParentFolder = remoteDirectory;
                    destinationFileName = sourceFile.getName();
                } else {
                    destinationParentFolder = separators.asPlatformFileName(destinationFile.getParent());
                    if (destinationParentFolder == null) {
                        destinationParentFolder = remoteDirectory;
                    }
                    destinationFileName = destinationFile.getName();
                }
                String targetFileName = destinationParentFolder + separators.getFileSeparator() + destinationFileName;
                this.deployArtifact(sourceURL, targetFileName, platform);
                deployedArtifacts.add(new File(targetFileName));
                double time = ((double)System.currentTimeMillis() - start) / 1000.0;
                deploymentTable.addRow(new String[]{sourceFile.toString(), destinationFileName, String.format("%.3f s", time)});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error deploying artifacts", e);
        }
    }

    @Override
    public DeployedArtifacts undeploy(DeployedArtifacts deployedArtifacts, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts failedArtifacts = new DeployedArtifacts();
        for (File file : deployedArtifacts) {
            CapturingApplicationConsole console = new CapturingApplicationConsole();
            Application application = platform.launch(Application.class, new Option[]{Executable.named((String)"rm"), Argument.of((Object)StringHelper.doubleQuoteIfNecessary((String)file.toString()), (Option[])new Option[0]), DisplayName.of((String)"Undeploy")});
            Throwable throwable = null;
            try {
                if (application.waitFor(new Option[0]) == 0) continue;
                StringBuilder message = new StringBuilder("Error undeploying ").append(file.toString()).append(" - rm returned ").append(application.exitValue()).append("\n").append("rm output:");
                for (String line : console.getCapturedOutputLines()) {
                    message.append(line);
                }
                for (String line : console.getCapturedErrorLines()) {
                    message.append(line);
                }
                failedArtifacts.add(file);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (application == null) continue;
                if (throwable != null) {
                    try {
                        application.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                application.close();
            }
        }
        return failedArtifacts;
    }

    protected ExecutorService createExecutor() {
        return null;
    }

    protected abstract void deployArtifact(URL var1, String var2, Platform var3);

    protected HttpServer createServer(ExecutorService executor, Map<String, DeploymentArtifact> artifacts) {
        try {
            LocalPlatform platform = LocalPlatform.get();
            InetAddress address = NetworkHelper.getFeasibleLocalHost();
            int port = platform.getAvailablePorts().next();
            HttpServer server = HttpServer.create(new InetSocketAddress(address, port), 0);
            server.createContext("/", new ArtifactsHandler(artifacts, this.optionsByType.asArray()));
            server.setExecutor(executor);
            server.start();
            return server;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create HTTP server", e);
        }
    }

    public static class BufferSize
    implements Option {
        private int bufferSize;

        public BufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }
    }

    public static class ArtifactsHandler
    implements HttpHandler {
        private final Map<String, DeploymentArtifact> artifacts;
        private final OptionsByType optionsByType;

        public ArtifactsHandler(Map<String, DeploymentArtifact> artifacts, Option ... options) {
            this.artifacts = artifacts;
            this.optionsByType = OptionsByType.of((Option[])options);
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            URI requestedURI = httpExchange.getRequestURI();
            String requestedPath = requestedURI.toString();
            DeploymentArtifact requestedArtifact = this.artifacts.get(requestedPath);
            if (requestedArtifact == null) {
                httpExchange.sendResponseHeaders(404, 0L);
                return;
            }
            URI sourceURI = requestedArtifact.getSourceFile().toURI();
            Path path = Paths.get(sourceURI);
            httpExchange.getResponseHeaders().set("Content-length", String.valueOf(Files.size(path)));
            httpExchange.getResponseHeaders().set("Content-type", "application/octet-stream");
            httpExchange.sendResponseHeaders(200, 0L);
            BufferSize bufferSize = (BufferSize)this.optionsByType.getOrSetDefault(BufferSize.class, (Option)new BufferSize(1000000));
            int bufferBytes = bufferSize.getBufferSize();
            byte[] buff = new byte[bufferBytes];
            try (InputStream data = sourceURI.toURL().openStream();
                 OutputStream os = httpExchange.getResponseBody();){
                int read;
                while ((read = data.read(buff, 0, bufferBytes)) > 0) {
                    os.write(buff, 0, read);
                }
            }
        }
    }
}

