/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.http;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.remote.http.HttpDeployer;
import java.net.URL;

public class WGetHttpDeployer
extends HttpDeployer {
    public static final String DEFAULT_WGET = "wget";
    private final String wgetCommand;

    public WGetHttpDeployer(Option ... options) {
        this(DEFAULT_WGET, options);
    }

    public WGetHttpDeployer(String wgetCommand, Option ... options) {
        super(options);
        this.wgetCommand = wgetCommand;
    }

    @Override
    protected void deployArtifact(URL sourceURL, String targetFileName, Platform platform) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = platform.launch(Application.class, new Option[]{Executable.named((String)this.wgetCommand), Argument.of((Object)"-O", (Option[])new Option[0]), Argument.of((Object)targetFileName, (Option[])new Option[0]), Argument.of((Object)sourceURL.toExternalForm(), (Option[])new Option[0]), DisplayName.of((String)"Deploy"), Console.of((ApplicationConsole)console)});){
            int exitCode = application.waitFor(new Option[0]);
            application.close();
            if (exitCode != 0) {
                StringBuilder message = new StringBuilder("Error deploying ").append(targetFileName).append(" - wget returned ").append(exitCode).append("\n").append("wget output:");
                for (String line : console.getCapturedOutputLines()) {
                    message.append(line);
                }
                for (String line : console.getCapturedErrorLines()) {
                    message.append(line);
                }
                throw new RuntimeException(message.toString());
            }
        }
    }
}

