/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.deferred.AbstractDeferred;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.ApplicationProcess;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.concurrent.ControllableRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannelServer;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.ClassPathModifier;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.JavaApplicationRunner;
import com.oracle.bedrock.runtime.java.features.JmxFeature;
import com.oracle.bedrock.runtime.java.options.ClassName;
import com.oracle.bedrock.runtime.java.options.JavaHome;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import com.oracle.bedrock.runtime.java.options.RemoteEvents;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.WaitToStart;
import com.oracle.bedrock.runtime.java.profiles.CommercialFeatures;
import com.oracle.bedrock.runtime.java.profiles.RemoteDebugging;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.Orphanable;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.remote.AbstractRemoteApplicationLauncher;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.java.options.JavaDeployment;
import com.oracle.bedrock.runtime.remote.options.Deployment;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

@Internal
public class RemoteJavaApplicationLauncher
extends AbstractRemoteApplicationLauncher<JavaApplication>
implements JavaApplicationLauncher<JavaApplication> {
    private SocketBasedRemoteChannelServer remoteChannel = new SocketBasedRemoteChannelServer();
    private ClassPath remoteClassPath;
    private Properties systemProperties = new Properties();

    public RemoteJavaApplicationLauncher() throws UnsupportedOperationException {
        try {
            this.remoteChannel.open();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Failed to create a " + this.getClass().getName() + " to launch the application remotely due to a communication problem", e);
        }
    }

    @Override
    protected void onLaunching(OptionsByType optionsByType) {
        optionsByType.get(RemoteDebugging.class, new Object[0]);
        optionsByType.get(CommercialFeatures.class, new Object[0]);
        JavaDeployment deployment = (JavaDeployment)optionsByType.getOrSetDefault(Deployment.class, (Option)JavaDeployment.automatic());
        if (deployment.isAutoDeployEnabled()) {
            PlatformSeparators separators = (PlatformSeparators)optionsByType.getOrSetDefault(PlatformSeparators.class, (Option)PlatformSeparators.forUnix());
            String thisDir = ".";
            String thisDirAllJars = thisDir + separators.getFileSeparator() + "*";
            this.remoteClassPath = new ClassPath(new String[]{thisDir, thisDirAllJars});
        } else {
            this.remoteClassPath = (ClassPath)optionsByType.get(ClassPath.class, new Object[0]);
        }
        RemoteEvents remoteEvents = (RemoteEvents)optionsByType.get(RemoteEvents.class, new Object[0]);
        remoteEvents.forEach((remoteEventListener, listenerOptions) -> this.remoteChannel.addListener(remoteEventListener, listenerOptions));
    }

    @Override
    protected void onLaunched(JavaApplication application, OptionsByType optionsByType) {
        WaitToStart waitToStart;
        if (JmxFeature.isSupportedBy((JavaApplication)application)) {
            application.add((Object)new JmxFeature());
        }
        if ((waitToStart = (WaitToStart)optionsByType.get(WaitToStart.class, new Object[0])).isEnabled()) {
            Timeout timeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
            final SocketBasedRemoteChannelServer server = this.remoteChannel;
            DeferredHelper.ensure((Deferred)new AbstractDeferred<Boolean>(){

                public Boolean get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
                    if (!server.getRemoteChannels().iterator().hasNext()) {
                        throw new TemporarilyUnavailableException((Deferred)this);
                    }
                    return true;
                }
            }, (Option[])new Option[]{DeferredHelper.within((Timeout)timeout)});
        }
    }

    @Override
    protected <P extends ApplicationProcess> P adapt(RemoteApplicationProcess process) {
        return (P)new RemoteJavaApplicationProcess(process, (ControllableRemoteChannel)this.remoteChannel, this.systemProperties);
    }

    @Override
    public Properties getEnvironmentVariables(Platform platform, OptionsByType optionsByType) {
        Properties properties = super.getEnvironmentVariables(platform, optionsByType);
        JavaHome javaHome = (JavaHome)optionsByType.get(JavaHome.class, new Object[0]);
        if (javaHome != null) {
            properties.put("JAVA_HOME", javaHome.get());
        }
        return properties;
    }

    @Override
    public String getCommandToExecute(Platform platform, OptionsByType optionsByType) {
        StringBuilder commandBuilder = new StringBuilder();
        JavaHome javaHome = (JavaHome)optionsByType.get(JavaHome.class, new Object[0]);
        Executable executable = (Executable)optionsByType.getOrSetDefault(Executable.class, (Option)Executable.named((String)"java"));
        if (javaHome == null) {
            commandBuilder.append(StringHelper.doubleQuoteIfNecessary((String)executable.getName()));
        } else {
            String javaHomePath;
            PlatformSeparators separators = (PlatformSeparators)optionsByType.getOrSetDefault(PlatformSeparators.class, (Option)PlatformSeparators.forUnix());
            String javaExecutable = javaHomePath = javaHome.get().trim();
            if (!javaHomePath.endsWith(separators.getFileSeparator())) {
                javaExecutable = javaExecutable + separators.getFileSeparator();
            }
            javaExecutable = javaExecutable + "bin";
            javaExecutable = javaExecutable + separators.getFileSeparator();
            javaExecutable = javaExecutable + executable.getName();
            commandBuilder.append(StringHelper.doubleQuoteIfNecessary((String)javaExecutable));
            Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
            if (diagnosticsTable != null) {
                diagnosticsTable.addRow(new String[]{"Java Home", javaHomePath});
                diagnosticsTable.addRow(new String[]{"Java Executable", javaExecutable});
            }
        }
        return commandBuilder.toString();
    }

    @Override
    public List<String> getCommandLineArguments(Platform platform, OptionsByType optionsByType) {
        String propertyValue;
        ArrayList<String> arguments = new ArrayList<String>();
        Table systemPropertiesTable = new Table(new Row[0]);
        systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
        systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
        String parentURI = "//${local.address}:" + this.remoteChannel.getPort();
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        String parentUriString = (String)evaluator.evaluate(parentURI, String.class);
        arguments.add("-Dbedrock.runtime.parent=" + parentUriString);
        systemPropertiesTable.addRow(new String[]{"bedrock.runtime.parent", parentUriString});
        Orphanable orphanable = (Orphanable)optionsByType.get(Orphanable.class, new Object[0]);
        arguments.add("-Dbedrock.runtime.orphanable=" + orphanable.isOrphanable());
        systemPropertiesTable.addRow(new String[]{"bedrock.runtime.orphanable", Boolean.toString(orphanable.isOrphanable())});
        arguments.add("-cp");
        ClassPathModifier modifier = (ClassPathModifier)optionsByType.getOrSetDefault(ClassPathModifier.class, (Option)ClassPathModifier.none());
        String classPath = modifier.applyQuotes(this.remoteClassPath.toString(optionsByType.asArray()));
        arguments.add(classPath);
        Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
        if (diagnosticsTable != null) {
            Table classPathTable = this.remoteClassPath.getTable();
            classPathTable.getOptions().add((Option)Cell.Separator.of((String)""));
            diagnosticsTable.addRow(new String[]{"Class Path", classPathTable.toString()});
        }
        for (JvmOption jvmOption : optionsByType.getInstancesOf(JvmOption.class)) {
            for (String value : jvmOption.resolve(optionsByType)) {
                arguments.add(value);
            }
        }
        this.systemProperties = ((SystemProperties)optionsByType.get(SystemProperties.class, new Object[0])).resolve(platform, optionsByType);
        for (String propertyName : this.systemProperties.stringPropertyNames()) {
            if (!propertyName.startsWith("bedrock.profile.") && propertyName.startsWith("bedrock")) continue;
            propertyValue = this.systemProperties.getProperty(propertyName);
            StringBuilder propertyBuilder = new StringBuilder();
            propertyBuilder.append("-D");
            propertyBuilder.append(propertyName);
            if (!propertyValue.isEmpty()) {
                propertyValue = StringHelper.doubleQuoteIfNecessary((String)propertyValue);
                propertyBuilder.append("=");
                propertyBuilder.append(propertyValue);
                systemPropertiesTable.addRow(new String[]{propertyName, propertyValue});
            }
            arguments.add(propertyBuilder.toString());
        }
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("bedrock.runtime.inherit.")) continue;
            propertyValue = System.getProperty(propertyName);
            propertyValue = (String)evaluator.evaluate(propertyValue, String.class);
            arguments.add(propertyValue);
        }
        if (diagnosticsTable != null) {
            diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
        }
        String applicationLauncherClassName = JavaApplicationRunner.class.getName();
        arguments.add(applicationLauncherClassName);
        ClassName className = (ClassName)optionsByType.get(ClassName.class, new Object[0]);
        if (className == null) {
            throw new IllegalArgumentException("Java Application ClassName not specified");
        }
        String applicationClassName = className.getName();
        arguments.add(applicationClassName);
        if (diagnosticsTable != null) {
            diagnosticsTable.addRow(new String[]{"Application Launcher", applicationLauncherClassName});
            diagnosticsTable.addRow(new String[]{"Application Class", applicationClassName});
        }
        List argList = ((Arguments)optionsByType.get(Arguments.class, new Object[0])).resolve(platform, optionsByType);
        optionsByType.add((Option)Arguments.of((List)argList));
        for (String argument : argList) {
            arguments.add(argument);
        }
        return arguments;
    }

    public static class RemoteJavaApplicationProcess
    implements JavaApplicationProcess {
        private RemoteApplicationProcess process;
        private ControllableRemoteChannel remoteChannel;
        private Properties systemProperties;

        public RemoteJavaApplicationProcess(RemoteApplicationProcess process, ControllableRemoteChannel remoteChannel, Properties systemProperties) {
            this.process = process;
            this.remoteChannel = remoteChannel;
            this.systemProperties = systemProperties;
        }

        public long getId() {
            return this.process.getId();
        }

        public Properties getSystemProperties() {
            return this.systemProperties;
        }

        public void close() {
            this.process.close();
            this.remoteChannel.close();
        }

        public int exitValue() {
            return this.process.exitValue();
        }

        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        public int waitFor(Option ... options) {
            return this.process.waitFor(options);
        }

        public <T> CompletableFuture<T> submit(RemoteCallable<T> callable, Option ... options) throws IllegalStateException {
            return this.remoteChannel.submit(callable, options);
        }

        public CompletableFuture<Void> submit(RemoteRunnable runnable, Option ... options) throws IllegalStateException {
            return this.remoteChannel.submit(runnable, options);
        }

        public void addListener(RemoteEventListener listener, Option ... options) {
            this.remoteChannel.addListener(listener, options);
        }

        public void removeListener(RemoteEventListener listener, Option ... options) {
            this.remoteChannel.removeListener(listener, options);
        }

        public CompletableFuture<Void> raise(RemoteEvent event, Option ... options) {
            return this.remoteChannel.raise(event, options);
        }
    }
}

