/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.io.FileHelper;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.options.BedrockRunner;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.options.Deployment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class JavaDeployment
implements Deployment {
    private boolean autoDeployEnabled;
    private HashSet<String> includePaths;
    private HashSet<String> excludeFileNames;
    private boolean excludeJDK;

    private JavaDeployment(boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        this.includePaths = new HashSet();
        this.excludeJDK = true;
        this.excludeFileNames = new HashSet();
        this.excludeFileNames.add("apple_provider.jar");
        this.excludeFileNames.add("classes.jar");
        this.excludeFileNames.add("charsets.jar");
        this.excludeFileNames.add("deploy.jar");
        this.excludeFileNames.add("dt.jar");
        this.excludeFileNames.add("dnsns.jar");
        this.excludeFileNames.add("idea_rt.jar");
        this.excludeFileNames.add("localedata.jar");
        this.excludeFileNames.add("jsse.jar");
        this.excludeFileNames.add("jce.jar");
        this.excludeFileNames.add("javaws.jar");
        this.excludeFileNames.add("jconsole.jar");
        this.excludeFileNames.add("management-agent.jar");
        this.excludeFileNames.add("plugin.jar");
        this.excludeFileNames.add("sa-jdi.jar");
        this.excludeFileNames.add("sunjce_provider.jar");
        this.excludeFileNames.add("sunpkcs11.jar");
        this.excludeFileNames.add("ui.jar");
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public JavaDeployment include(String path) {
        this.includePaths.add(path);
        return this;
    }

    public JavaDeployment exclude(String fileName) {
        this.includePaths.remove(fileName);
        this.excludeFileNames.add(fileName);
        return this;
    }

    @Override
    public List<DeploymentArtifact> getDeploymentArtifacts(Platform platform, OptionsByType optionsByType) throws FileNotFoundException, IOException {
        ArrayList<DeploymentArtifact> deploymentArtifacts = new ArrayList<DeploymentArtifact>();
        File javaHomeFile = new File(System.getProperty("java.home"));
        String javaHome = javaHomeFile.getCanonicalPath();
        if (javaHomeFile.getName().equals("jre")) {
            javaHome = javaHomeFile.getParentFile().getCanonicalPath();
        }
        if (this.autoDeployEnabled) {
            ClassPath classPath = (ClassPath)optionsByType.get(ClassPath.class, new Object[0]);
            BedrockRunner bedrockRunner = (BedrockRunner)optionsByType.get(BedrockRunner.class, new Object[0]);
            if (bedrockRunner != null && bedrockRunner.isEnabled()) {
                classPath = new ClassPath(new ClassPath[]{classPath, ClassPath.ofClass((Class)bedrockRunner.getClassOfRunner())});
                optionsByType.add((Option)classPath);
            }
            for (String path : classPath) {
                File file;
                path = path.trim();
                if (this.excludeJDK && path.startsWith(javaHome) || path.endsWith("*") || path.endsWith(".") || path.endsWith("..") || !(file = new File(path)).exists()) continue;
                if (file.isFile()) {
                    String fileName = file.getName();
                    if (this.excludeFileNames.contains(fileName.toLowerCase())) continue;
                    String destinationFile = file.getName();
                    DeploymentArtifact artifact = new DeploymentArtifact(file, new File(destinationFile));
                    deploymentArtifacts.add(artifact);
                    continue;
                }
                File temporaryFile = File.createTempFile("bedrock-deployment-", ".jar");
                FileHelper.zip(Collections.singletonList(file), (String)"", (String)temporaryFile.getAbsolutePath());
                DeploymentArtifact artifact = new DeploymentArtifact(temporaryFile, new File(temporaryFile.getName()), true);
                deploymentArtifacts.add(artifact);
            }
        }
        return deploymentArtifacts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaDeployment)) {
            return false;
        }
        JavaDeployment that = (JavaDeployment)other;
        if (this.autoDeployEnabled != that.autoDeployEnabled) {
            return false;
        }
        if (!this.excludeFileNames.equals(that.excludeFileNames)) {
            return false;
        }
        return this.includePaths.equals(that.includePaths);
    }

    public int hashCode() {
        int result = this.autoDeployEnabled ? 1 : 0;
        result = 31 * result + this.includePaths.hashCode();
        result = 31 * result + this.excludeFileNames.hashCode();
        return result;
    }

    public static JavaDeployment automatic() {
        return new JavaDeployment(true);
    }

    public static JavaDeployment empty() {
        return new JavaDeployment(false);
    }
}

