/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.remote.DeployedArtifacts;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;

public abstract class FileShareDeployer
implements Deployer {
    private String localShareName;
    private String remoteShareName;
    private OptionsByType optionsByType;

    protected FileShareDeployer(String localShareName, String remoteShareName, Option ... options) {
        this.localShareName = localShareName;
        this.remoteShareName = remoteShareName;
        this.optionsByType = OptionsByType.of((Option[])options);
    }

    public String getLocalShareName() {
        return this.localShareName;
    }

    public String getRemoteShareName() {
        return this.remoteShareName;
    }

    @Override
    public DeployedArtifacts deploy(List<DeploymentArtifact> artifactsToDeploy, String remoteDirectory, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts deployedArtifacts = new DeployedArtifacts();
        OptionsByType combinedOptions = platform == null ? OptionsByType.empty() : OptionsByType.of((OptionsByType)platform.getOptions());
        Table deploymentTable = new Table(new Row[0]);
        combinedOptions.addAll(this.optionsByType);
        combinedOptions.addAll(deploymentOptions);
        PlatformSeparators separators = (PlatformSeparators)combinedOptions.get(PlatformSeparators.class, new Object[0]);
        File remoteShareFile = new File(this.remoteShareName);
        for (DeploymentArtifact artifact : artifactsToDeploy) {
            double start = System.currentTimeMillis();
            try {
                boolean cleanup;
                String destination;
                File sourceFile = artifact.getSourceFile();
                Path localCopy = new File(this.localShareName, sourceFile.getName()).toPath();
                Files.copy(artifact.getSourceFile().toPath(), localCopy, StandardCopyOption.REPLACE_EXISTING);
                String sourceName = artifact.getSourceFile().getName();
                File destinationFile = artifact.getDestinationFile();
                if (destinationFile == null) {
                    destination = remoteDirectory + separators.getFileSeparator() + sourceName;
                } else {
                    String destinationFilePath = separators.asPlatformFileName(destinationFile.getParent());
                    if (destinationFilePath == null) {
                        String dirName = separators.asPlatformFileName(remoteDirectory);
                        destination = dirName + separators.getFileSeparator() + destinationFile.getPath();
                    } else {
                        destination = separators.asPlatformFileName(destinationFile.getCanonicalPath());
                    }
                }
                String source = new File(remoteShareFile, sourceName).getCanonicalPath();
                if (!source.equals(destination) && (cleanup = this.performRemoteCopy(source, destination, platform, combinedOptions))) {
                    Files.delete(localCopy);
                }
                deployedArtifacts.add(new File(destination));
                double time = ((double)System.currentTimeMillis() - start) / 1000.0;
                deploymentTable.addRow(new String[]{sourceFile.toString(), String.valueOf(destination), String.format("%.3f s", time)});
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deploy " + artifact, e);
            }
        }
        Table diagnosticsTable = (Table)this.optionsByType.get(Table.class, new Object[0]);
        if (diagnosticsTable != null) {
            diagnosticsTable.addRow(new String[]{"Application Deployments ", deploymentTable.toString()});
        }
        return deployedArtifacts;
    }

    @Override
    public DeployedArtifacts undeploy(DeployedArtifacts deployedArtifacts, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts failedArtifacts = new DeployedArtifacts();
        for (File file : deployedArtifacts) {
            try {
                file.delete();
            }
            catch (Exception e) {
                failedArtifacts.add(file);
            }
        }
        return failedArtifacts;
    }

    protected abstract boolean performRemoteCopy(String var1, String var2, Platform var3, OptionsByType var4) throws IOException;
}

