/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.ssh;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.runtime.remote.options.FileShareDeployer;
import com.oracle.bedrock.runtime.remote.ssh.JSchRemoteTerminal;

public class JSchFileShareDeployer
extends FileShareDeployer {
    private JSchFileShareDeployer(String localShareName, String remoteShareName, Option ... options) {
        super(localShareName, remoteShareName, options);
    }

    @Override
    protected boolean performRemoteCopy(String source, String destination, Platform platform, OptionsByType deploymentOptions) {
        if (platform instanceof RemotePlatform) {
            JSchRemoteTerminal terminal = new JSchRemoteTerminal((RemotePlatform)platform);
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)platform.getOptions());
            optionsByType.addAll(deploymentOptions.asArray());
            terminal.moveFile(source, destination, optionsByType);
            return false;
        }
        throw new IllegalArgumentException("The platform argument must be an instance of a RemotePlatform");
    }

    public static Deployer sshFileShareDeployer(String localShareName, String remoteShareName, Option ... options) {
        return new JSchFileShareDeployer(localShareName, remoteShareName, options);
    }
}

