/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Shell;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.AbstractRemoteTerminal;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.RemoteTerminal;
import com.oracle.bedrock.runtime.remote.ssh.JSchSessionFactory;
import com.oracle.bedrock.runtime.remote.ssh.JSchSocketFactory;
import com.oracle.bedrock.runtime.remote.ssh.JschRemoteApplicationProcess;
import com.oracle.bedrock.table.Table;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSchRemoteTerminal
extends AbstractRemoteTerminal {
    private static Logger LOGGER = Logger.getLogger(JSchRemoteTerminal.class.getName());
    protected JSchSessionFactory sessionFactory;

    public JSchRemoteTerminal(RemotePlatform platform) {
        this(platform, new JSchSessionFactory());
    }

    public JSchRemoteTerminal(RemotePlatform platform, JSchSessionFactory sessionFactory) {
        super(platform);
        this.sessionFactory = sessionFactory;
    }

    @Override
    public RemoteApplicationProcess launch(RemoteTerminal.Launchable launchable, Class<? extends Application> applicationClass, OptionsByType optionsByType) {
        RemotePlatform platform = this.getRemotePlatform();
        JSchSocketFactory socketFactory = new JSchSocketFactory();
        Session session = null;
        try {
            String format;
            session = this.sessionFactory.createSession(platform.getAddress().getHostName(), platform.getPort(), platform.getUserName(), platform.getAuthentication(), socketFactory, optionsByType);
            ChannelExec execChannel = (ChannelExec)session.openChannel("exec");
            optionsByType.add((Option)Variable.with((String)"local.address", (Object)socketFactory.getLastLocalAddress().getHostAddress()));
            String environmentVariables = "";
            Properties variables = launchable.getEnvironmentVariables((Platform)platform, optionsByType);
            Shell shell = (Shell)optionsByType.getOrSetDefault(Shell.class, (Option)Shell.isUnknown());
            switch (shell.getType()) {
                case SH: 
                case BASH: {
                    format = "export %s=%s ; ";
                    break;
                }
                case CSH: 
                case TSCH: {
                    format = "setenv %s %s ; ";
                    break;
                }
                default: {
                    format = "export %s=%s ; ";
                }
            }
            for (String variableName : variables.stringPropertyNames()) {
                environmentVariables = environmentVariables + String.format(format, variableName, StringHelper.doubleQuoteIfNecessary((String)variables.getProperty(variableName)));
            }
            String executableName = launchable.getCommandToExecute((Platform)platform, optionsByType);
            StringBuilder command = new StringBuilder(executableName);
            List<String> arguments = launchable.getCommandLineArguments((Platform)platform, optionsByType);
            for (String arg : arguments) {
                command.append(" ").append(arg);
            }
            WorkingDirectory workingDirectory = (WorkingDirectory)optionsByType.get(WorkingDirectory.class, new Object[0]);
            String remoteCommand = environmentVariables + String.format("cd %s ; %s", workingDirectory.resolve((Platform)platform, optionsByType), command);
            execChannel.setCommand(remoteCommand);
            JschRemoteApplicationProcess process = new JschRemoteApplicationProcess(session, execChannel);
            Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
            if (diagnosticsTable != null && LOGGER.isLoggable(Level.INFO)) {
                diagnosticsTable.addRow(new String[]{"Application Executable ", executableName});
                LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
            }
            execChannel.connect(session.getTimeout());
            return process;
        }
        catch (JSchException e) {
            if (session != null) {
                session.disconnect();
            }
            throw new RuntimeException("Failed to create remote application", e);
        }
    }

    @Override
    public void makeDirectories(String directoryName, OptionsByType optionsByType) {
        Session session = null;
        try {
            RemotePlatform platform = this.getRemotePlatform();
            JSchSocketFactory socketFactory = new JSchSocketFactory();
            session = this.sessionFactory.createSession(platform.getAddress().getHostName(), platform.getPort(), platform.getUserName(), platform.getAuthentication(), socketFactory, optionsByType);
            ChannelExec execChannel = (ChannelExec)session.openChannel("exec");
            execChannel.setCommand("mkdir -p " + directoryName);
            JschRemoteApplicationProcess process = new JschRemoteApplicationProcess(session, execChannel);
            execChannel.connect(session.getTimeout());
            process.waitFor(new Option[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating remote directories " + directoryName, e);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public void moveFile(String source, String destination, OptionsByType optionsByType) {
        Session session = null;
        try {
            RemotePlatform platform = this.getRemotePlatform();
            JSchSocketFactory socketFactory = new JSchSocketFactory();
            session = this.sessionFactory.createSession(platform.getAddress().getHostName(), platform.getPort(), platform.getUserName(), platform.getAuthentication(), socketFactory, optionsByType);
            ChannelExec execChannel = (ChannelExec)session.openChannel("exec");
            String moveCommand = String.format("mv %s %s", source, destination);
            execChannel.setCommand(moveCommand);
            JschRemoteApplicationProcess process = new JschRemoteApplicationProcess(session, execChannel);
            execChannel.connect(session.getTimeout());
            process.waitFor(new Option[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error moving file from " + source + " to " + destination, e);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

