/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.options.StrictHostChecking;
import com.oracle.bedrock.runtime.remote.ssh.JSchBasedAuthentication;
import com.oracle.bedrock.runtime.remote.ssh.JSchSocketFactory;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class JSchSessionFactory {
    protected JSch jsch;

    public JSchSessionFactory() {
        this(new JSch());
    }

    public JSchSessionFactory(JSch jsch) {
        this.jsch = jsch;
    }

    public Session createSession(String hostName, int port, String userName, Authentication authentication, JSchSocketFactory socketFactory, OptionsByType optionsByType) throws JSchException {
        if (authentication instanceof JSchBasedAuthentication) {
            ((JSchBasedAuthentication)authentication).configureFramework(this.jsch);
        }
        Session session = this.jsch.getSession(userName, hostName, port);
        session.setSocketFactory((SocketFactory)socketFactory);
        session.setDaemonThread(true);
        Timeout timeout = (Timeout)optionsByType.getOrDefault(Timeout.class, (Option)Timeout.autoDetect());
        int timeoutMS = (int)timeout.getDuration().to(TimeUnit.MILLISECONDS);
        session.setTimeout(timeoutMS);
        if (authentication instanceof JSchBasedAuthentication) {
            ((JSchBasedAuthentication)authentication).configureSession(session);
        }
        Properties config = new Properties();
        StrictHostChecking strictHostChecking = (StrictHostChecking)optionsByType.get(StrictHostChecking.class, new Object[0]);
        config.put("StrictHostKeyChecking", strictHostChecking.isEnabled() ? "yes" : "no");
        session.setConfig(config);
        session.connect();
        return session;
    }
}

