/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public class JschRemoteApplicationProcess
implements RemoteApplicationProcess {
    protected Session session;
    protected ChannelExec channel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream errorStream;
    private Integer exitStatus;

    public JschRemoteApplicationProcess(Session session, ChannelExec channel) {
        this.session = session;
        this.channel = channel;
        try {
            this.inputStream = channel.getInputStream();
            this.outputStream = channel.getOutputStream();
            this.errorStream = channel.getErrStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to obtain remote streams", e);
        }
        this.exitStatus = null;
    }

    public long getId() {
        return this.channel.getId();
    }

    public void close() {
        if (this.exitStatus == null && !this.channel.isClosed()) {
            this.exitStatus = this.channel.getExitStatus();
        }
        this.channel.disconnect();
        this.session.disconnect();
    }

    public int waitFor(Option ... options) {
        if (this.exitStatus == null) {
            if (this.channel == null || this.session == null) {
                throw new RuntimeException("The remote application has terminated.  No exit status is available");
            }
            int status = this.channel.getExitStatus();
            OptionsByType optionsByType = OptionsByType.of((Option[])options);
            Timeout timeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
            long timeRemaining = timeout.to(TimeUnit.MILLISECONDS);
            while (status == -1 && timeRemaining >= 0L) {
                try {
                    long waitTime = 500L;
                    Thread.sleep(waitTime);
                    if ((timeRemaining -= waitTime) > 0L && timeRemaining < waitTime) {
                        timeRemaining = waitTime;
                    }
                    status = this.channel.getExitStatus();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for application to terminate", e);
                }
            }
            this.exitStatus = status;
        }
        return this.exitStatus;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public int exitValue() {
        return this.exitStatus == null ? -1 : this.exitStatus;
    }
}

