/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.diagnostics.DiagnosticsRecording;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.DeployedArtifacts;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.runtime.remote.ssh.JSchSessionFactory;
import com.oracle.bedrock.runtime.remote.ssh.JSchSocketFactory;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SftpDeployer
implements Deployer {
    private JSchSessionFactory sessionFactory;

    public SftpDeployer() {
        this(new JSchSessionFactory());
    }

    public SftpDeployer(JSchSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public DeployedArtifacts deploy(List<DeploymentArtifact> artifactsToDeploy, String remoteDirectory, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts deployedArtifacts;
        block20: {
            deployedArtifacts = new DeployedArtifacts();
            if (artifactsToDeploy == null || artifactsToDeploy.isEmpty()) {
                return deployedArtifacts;
            }
            if (!(platform instanceof RemotePlatform)) {
                throw new IllegalArgumentException("The platform parameter must be an instance of RemotePlatform");
            }
            Table deploymentTable = new Table(new Row[0]);
            JSchSocketFactory socketFactory = new JSchSocketFactory();
            RemotePlatform remotePlatform = (RemotePlatform)platform;
            String userName = remotePlatform.getUserName();
            Authentication authentication = remotePlatform.getAuthentication();
            String hostName = remotePlatform.getAddress().getHostName();
            int port = remotePlatform.getPort();
            OptionsByType optionsByType = OptionsByType.empty();
            optionsByType.addAll(platform.getOptions());
            optionsByType.addAll(deploymentOptions);
            Session session = null;
            try {
                session = this.sessionFactory.createSession(hostName, port, userName, authentication, socketFactory, optionsByType);
                PlatformSeparators separators = (PlatformSeparators)optionsByType.get(PlatformSeparators.class, new Object[0]);
                if (artifactsToDeploy.size() <= 0) break block20;
                ChannelSftp sftpChannel = null;
                try {
                    sftpChannel = (ChannelSftp)session.openChannel("sftp");
                    sftpChannel.connect(session.getTimeout());
                    try {
                        sftpChannel.lstat(remoteDirectory);
                    }
                    catch (SftpException _ignored) {
                        sftpChannel.mkdir(remoteDirectory);
                        deployedArtifacts.add(new File(remoteDirectory));
                    }
                    for (DeploymentArtifact artifactToDeploy : artifactsToDeploy) {
                        String destinationFileName;
                        File sourceFile = artifactToDeploy.getSourceFile();
                        File destinationFile = artifactToDeploy.getDestinationFile();
                        if (destinationFile == null) {
                            sftpChannel.cd(remoteDirectory);
                            destinationFileName = sourceFile.getName();
                            deployedArtifacts.add(new File(remoteDirectory, destinationFileName));
                        } else {
                            String destinationFilePath = separators.asPlatformFileName(destinationFile.getParent());
                            String dirName = destinationFilePath == null ? separators.asPlatformFileName(remoteDirectory) : separators.asPlatformFileName(destinationFilePath);
                            sftpChannel.cd(dirName);
                            destinationFileName = destinationFile.getName();
                            deployedArtifacts.add(new File(dirName, destinationFileName));
                        }
                        double start = System.currentTimeMillis();
                        sftpChannel.put((InputStream)new FileInputStream(sourceFile), destinationFileName);
                        double time = ((double)System.currentTimeMillis() - start) / 1000.0;
                        deploymentTable.addRow(new String[]{sourceFile.toString(), String.valueOf(destinationFile), String.format("%.3f s", time)});
                    }
                    Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
                    if (diagnosticsTable != null) {
                        diagnosticsTable.addRow(new String[]{"Application Deployments ", deploymentTable.toString()});
                    }
                }
                catch (SftpException | IOException e) {
                    throw new RuntimeException("Failed to deploy application", e);
                }
                finally {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                }
            }
            catch (JSchException e) {
                throw new RuntimeException("Failed to deploy application", e);
            }
            finally {
                if (session != null) {
                    session.disconnect();
                }
            }
        }
        return deployedArtifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployedArtifacts undeploy(DeployedArtifacts deployedArtifacts, Platform platform, Option ... deploymentOptions) {
        DeployedArtifacts failedArtifacts;
        block28: {
            failedArtifacts = new DeployedArtifacts();
            if (!(platform instanceof RemotePlatform)) {
                throw new IllegalArgumentException("The platform parameter must be an instance of RemotePlatform");
            }
            JSchSocketFactory socketFactory = new JSchSocketFactory();
            RemotePlatform remotePlatform = (RemotePlatform)platform;
            String userName = remotePlatform.getUserName();
            Authentication authentication = remotePlatform.getAuthentication();
            String hostName = remotePlatform.getAddress().getHostName();
            int port = remotePlatform.getPort();
            OptionsByType optionsByType = OptionsByType.empty();
            optionsByType.addAll(platform.getOptions());
            optionsByType.addAll(deploymentOptions);
            Session session = null;
            try {
                session = this.sessionFactory.createSession(hostName, port, userName, authentication, socketFactory, optionsByType);
                if (deployedArtifacts.size() <= 0) break block28;
                ChannelSftp sftpChannel = null;
                try (DiagnosticsRecording diagnostics = DiagnosticsRecording.section((String)"Remote Platform");){
                    sftpChannel = (ChannelSftp)session.openChannel("sftp");
                    sftpChannel.connect(session.getTimeout());
                    for (File file : deployedArtifacts) {
                        try {
                            sftpChannel.rm(file.toString());
                            diagnostics.add(new String[]{file.toString()});
                        }
                        catch (SftpException exception) {
                            try {
                                sftpChannel.rmdir(file.toString());
                                diagnostics.add(new String[]{file.toString() + " (directory)"});
                            }
                            catch (SftpException e) {
                                diagnostics.add(new String[]{file.toString() + " (failed to undeploy)"});
                                failedArtifacts.add(file);
                            }
                        }
                    }
                }
                finally {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                }
            }
            catch (JSchException e) {
                throw new RuntimeException("Failed to undeploy application", e);
            }
            finally {
                if (session != null) {
                    session.disconnect();
                }
            }
        }
        return failedArtifacts;
    }
}

