/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.AbstractApplication;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.callable.GetSystemProperty;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteMethodInvocation;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.util.ProxyHelper;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

@Internal
public abstract class AbstractJavaApplication<P extends JavaApplicationProcess>
extends AbstractApplication<P>
implements JavaApplication {
    public AbstractJavaApplication(Platform platform, P process, OptionsByType optionsByType) {
        super(platform, process, optionsByType);
    }

    @Override
    public Properties getSystemProperties() {
        return ((JavaApplicationProcess)this.process).getSystemProperties();
    }

    @Override
    public String getSystemProperty(String name) {
        try {
            return this.submit(new GetSystemProperty(name), new Option[0]).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error getting System property " + name, e);
        }
    }

    @Override
    public <T> CompletableFuture<T> submit(RemoteCallable<T> callable, Option ... options) throws IllegalStateException {
        return ((JavaApplicationProcess)this.process).submit(callable, options);
    }

    @Override
    public CompletableFuture<Void> submit(RemoteRunnable runnable, Option ... options) throws IllegalStateException {
        return ((JavaApplicationProcess)this.process).submit(runnable, options);
    }

    @Override
    public void addListener(RemoteEventListener listener, Option ... options) {
        ((JavaApplicationProcess)this.process).addListener(listener, options);
    }

    @Override
    public void removeListener(RemoteEventListener listener, Option ... options) {
        ((JavaApplicationProcess)this.process).removeListener(listener, options);
    }

    @Override
    public CompletableFuture<Void> raise(RemoteEvent event, Option ... options) {
        return ((JavaApplicationProcess)this.process).raise(event, options);
    }

    @Override
    public <T> T getProxyFor(Class<T> classToProxy, RemoteCallable<T> instanceProducer, RemoteMethodInvocation.Interceptor interceptor) {
        return (T)ProxyHelper.createProxyOf(classToProxy, new ProxyMethodInterceptor<T>(instanceProducer, interceptor));
    }

    private class ProxyMethodInterceptor<T>
    implements MethodInterceptor {
        private RemoteCallable<T> instanceProducer;
        private RemoteMethodInvocation.Interceptor interceptor;

        public ProxyMethodInterceptor(RemoteCallable<T> instanceProducer, RemoteMethodInvocation.Interceptor interceptor) {
            this.instanceProducer = instanceProducer;
            this.interceptor = interceptor;
        }

        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (this.interceptor != null) {
                this.interceptor.onBeforeRemoteInvocation(method, args);
            }
            RemoteMethodInvocation<T> invocation = new RemoteMethodInvocation<T>(this.instanceProducer, method.getName(), args, this.interceptor);
            CompletableFuture<Object> future = AbstractJavaApplication.this.submit(invocation, new Option[0]);
            try {
                Object result = future.get();
                if (this.interceptor != null) {
                    result = this.interceptor.onAfterRemoteInvocation(method, args, result);
                }
                return result;
            }
            catch (Exception e) {
                if (this.interceptor == null) {
                    throw e;
                }
                throw this.interceptor.onRemoteInvocationException(method, args, e);
            }
        }
    }
}

