/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.JvmOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaModules
implements Option,
Profile {
    private final boolean enabled;
    private final Set<String> modules;

    private JavaModules(boolean enabled, Set<String> modules) {
        this.enabled = enabled;
        this.modules = modules;
    }

    public static JavaModules enabled(boolean enabled, String ... modules) {
        Set<String> moduleSet = modules == null || modules.length == 0 ? Collections.emptySet() : Arrays.stream(modules).filter(Objects::nonNull).collect(Collectors.toSet());
        return new JavaModules(enabled, moduleSet);
    }

    public static JavaModules enabled(String ... modules) {
        return JavaModules.enabled(true, modules);
    }

    @OptionsByType.Default
    public static JavaModules disabled() {
        return JavaModules.enabled(false, new String[0]);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        this.modules.forEach(module -> optionsByType.add((Option)JvmOptions.include("--add-exports", module + "/com.oracle.coherence.server=com.oracle.bedrock.runtime", "--add-modules", module)));
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaModules)) {
            return false;
        }
        JavaModules other = (JavaModules)o;
        return this.enabled == other.enabled;
    }

    public int hashCode() {
        return this.enabled ? 1 : 0;
    }
}

