/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class SystemProperties
implements Option.Collector<SystemProperty, SystemProperties>,
ComposableOption<SystemProperties> {
    public static final HashSet<String> STANDARD_SYSTEM_PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add("java.version");
            this.add("java.vendor");
            this.add("java.vendor.url");
            this.add("java.home");
            this.add("java.vm.specification.version");
            this.add("java.vm.specification.vendor");
            this.add("java.vm.specification.name");
            this.add("java.vm.version");
            this.add("java.vm.vendor");
            this.add("java.vm.name");
            this.add("java.specification.version");
            this.add("java.specification.vendor");
            this.add("java.specification.name");
            this.add("java.class.version");
            this.add("java.class.path");
            this.add("java.library.path");
            this.add("java.io.tmpdir");
            this.add("java.compiler");
            this.add("java.ext.dirs");
            this.add("os.name");
            this.add("os.arch");
            this.add("os.version");
            this.add("file.separator");
            this.add("path.separator");
            this.add("line.separator");
            this.add("user.name");
            this.add("user.home");
            this.add("user.dir");
        }
    };
    private LinkedHashMap<String, SystemProperty> properties = new LinkedHashMap();

    @OptionsByType.Default
    public SystemProperties() {
    }

    public SystemProperties(Map<String, String> properties) {
        this();
        for (String name : properties.keySet()) {
            this.properties.put(name, SystemProperty.of(name, properties.get(name), new Option[0]));
        }
    }

    public SystemProperties(Properties properties) {
        this();
        for (String key : properties.stringPropertyNames()) {
            this.properties.put(key, SystemProperty.of(key, properties.getProperty(key), new Option[0]));
        }
    }

    public SystemProperties(SystemProperties systemProperties) {
        this();
        this.properties.putAll(systemProperties.properties);
    }

    public SystemProperties(SystemProperty ... properties) {
        this();
        if (properties != null) {
            for (SystemProperty property : properties) {
                this.add(property);
            }
        }
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public SystemProperties add(SystemProperty ... properties) {
        if (properties == null || properties.length == 0) {
            return this;
        }
        SystemProperties systemProperties = new SystemProperties(this);
        for (SystemProperty property : properties) {
            systemProperties.properties.put(property.getName(), property);
        }
        return systemProperties;
    }

    public SystemProperties addIfAbsent(SystemProperty property) {
        if (property == null || this.properties.containsKey(property.getName())) {
            return this;
        }
        return this.add(property);
    }

    public SystemProperties remove(String propertyName) {
        if (propertyName == null || propertyName.isEmpty() || !this.contains(propertyName)) {
            return this;
        }
        SystemProperties systemProperties = new SystemProperties(this);
        systemProperties.properties.remove(propertyName);
        return systemProperties;
    }

    public SystemProperties addAll(Map<String, Object> properties) {
        SystemProperties systemProperties = new SystemProperties(this);
        for (String name : properties.keySet()) {
            systemProperties.properties.put(name, SystemProperty.of(name, properties.get(name), new Option[0]));
        }
        return systemProperties;
    }

    public SystemProperties addAll(SystemProperties properties) {
        SystemProperties systemProperties = new SystemProperties(this);
        Iterator<SystemProperty> iterator = properties.iterator();
        while (iterator.hasNext()) {
            SystemProperty property = iterator.next();
            systemProperties.properties.put(property.getName(), property);
        }
        return systemProperties;
    }

    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public SystemProperty get(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            SystemProperty property = this.properties.get(name);
            return property.getValue();
        }
        return null;
    }

    public Properties resolve(Platform platform, OptionsByType optionsByType) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        Properties properties = new Properties();
        for (SystemProperty property : this.properties.values()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (value instanceof SystemProperty.ContextSensitiveValue) {
                SystemProperty.ContextSensitiveValue contextSensitiveValue = (SystemProperty.ContextSensitiveValue)value;
                value = contextSensitiveValue.resolve(name, platform, optionsByType);
            }
            if (value instanceof Iterator) {
                Iterator iterator = (Iterator)value;
                if (iterator.hasNext()) {
                    value = iterator.next().toString();
                } else {
                    throw new IndexOutOfBoundsException(String.format("No more values available for the property [%s]", name));
                }
            }
            if (value == null) continue;
            String expression = value.toString().trim();
            if (!expression.isEmpty()) {
                Object result = evaluator.evaluate(expression, Object.class);
                expression = result == null ? "" : result.toString();
            }
            OptionsByType propertyOptions = property.getOptions();
            Iterable handlers = propertyOptions.getInstancesOf(SystemProperty.ResolveHandler.class);
            for (SystemProperty.ResolveHandler handler : handlers) {
                try {
                    handler.onResolve(name, expression, optionsByType);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            properties.put(name, expression);
        }
        return properties;
    }

    public SystemProperties with(SystemProperty property) {
        return this.add(property);
    }

    public SystemProperties without(SystemProperty property) {
        return this.remove(property.getName());
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(SystemProperty.class)) {
            return this.properties.values();
        }
        return Collections.EMPTY_LIST;
    }

    public SystemProperties compose(SystemProperties other) {
        return this.addAll(other);
    }

    public Iterator<SystemProperty> iterator() {
        return this.properties.values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemProperties)) {
            return false;
        }
        SystemProperties that = (SystemProperties)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

