/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.EnvironmentVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;

public class EnvironmentVariables
implements Option.Collector<EnvironmentVariable, EnvironmentVariables> {
    private Source source;
    private LinkedHashMap<String, EnvironmentVariable> variables;

    public EnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.source = environmentVariables.getSource();
        this.variables = new LinkedHashMap<String, EnvironmentVariable>(environmentVariables.variables);
    }

    public EnvironmentVariables(Source source) {
        this.source = source;
        this.variables = new LinkedHashMap();
    }

    public Source getSource() {
        return this.source;
    }

    public static EnvironmentVariables of(Source source) {
        return new EnvironmentVariables(source);
    }

    public static EnvironmentVariables custom() {
        return new EnvironmentVariables(Source.Custom);
    }

    @OptionsByType.Default
    public static EnvironmentVariables inherited() {
        return new EnvironmentVariables(Source.ThisApplication);
    }

    public EnvironmentVariables set(String name, Object value) {
        return this.with(EnvironmentVariable.of(name, value));
    }

    public EnvironmentVariables set(String name, Iterator<?> iterator) {
        return this.with(EnvironmentVariable.of(name, iterator));
    }

    public Properties realize(Platform platform, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        Properties properties = new Properties();
        for (EnvironmentVariable variable : this.variables.values()) {
            String name = variable.getName();
            Object value = variable.getValue();
            if (value == null) continue;
            if (value instanceof EnvironmentVariable.ContextSensitiveValue) {
                EnvironmentVariable.ContextSensitiveValue contextSensitiveValue = (EnvironmentVariable.ContextSensitiveValue)value;
                value = contextSensitiveValue.getValue(name, platform, options);
            }
            if (value instanceof Iterator) {
                Iterator iterator = (Iterator)value;
                if (iterator.hasNext()) {
                    value = iterator.next().toString();
                } else {
                    throw new IndexOutOfBoundsException(String.format("No more values available for the variable [%s]", name));
                }
            }
            if (value == null) continue;
            String expression = value.toString().trim();
            if (!expression.isEmpty()) {
                Object result = evaluator.evaluate(expression, Object.class);
                expression = result == null ? "" : result.toString();
            }
            properties.put(name, expression);
        }
        return properties;
    }

    public EnvironmentVariables with(Collection<EnvironmentVariable> variables) {
        if (variables == null || variables.isEmpty()) {
            return this;
        }
        EnvironmentVariables environmentVariables = new EnvironmentVariables(this);
        for (EnvironmentVariable variable : variables) {
            environmentVariables.variables.put(variable.getName(), variable);
        }
        return environmentVariables;
    }

    public EnvironmentVariables with(EnvironmentVariable variable) {
        EnvironmentVariables environmentVariables = new EnvironmentVariables(this);
        environmentVariables.variables.put(variable.getName(), variable);
        return environmentVariables;
    }

    public EnvironmentVariables without(EnvironmentVariable variable) {
        if (this.variables.containsKey(variable.getName())) {
            EnvironmentVariables environmentVariables = new EnvironmentVariables(this);
            environmentVariables.variables.remove(variable);
            return environmentVariables;
        }
        return this;
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(EnvironmentVariable.class)) {
            return this.variables.values();
        }
        return Collections.EMPTY_LIST;
    }

    public Iterator<EnvironmentVariable> iterator() {
        return this.variables.values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnvironmentVariables)) {
            return false;
        }
        EnvironmentVariables that = (EnvironmentVariables)o;
        if (this.source != that.source) {
            return false;
        }
        return this.variables.equals(that.variables);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + this.variables.hashCode();
        return result;
    }

    public static enum Source {
        ThisApplication,
        TargetPlatform,
        Custom;

    }
}

